% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-based-parameter-assessment.R
\name{plot_feature_stability_mb_facet}
\alias{plot_feature_stability_mb_facet}
\title{Feature Stability - Cluster Membership Facet Plot}
\usage{
plot_feature_stability_mb_facet(
  feature_object_list,
  text_size = 5,
  n_facet_cols = 3,
  point_size = 0.3
)
}
\arguments{
\item{feature_object_list}{An object or a concatenation of objects returned by the
`get_feature_stability` method}

\item{text_size}{The size of the cluster label}

\item{n_facet_cols}{The number of facet's columns.}

\item{point_size}{The size of the points displayed on the plot.}
}
\value{
A ggplot2 object.
}
\description{
Display a facet of plots where each subpanel is associated with
a feature set and illustrates the distribution of the most frequent partition
over the UMAP embedding.
}
\examples{
set.seed(2021)
# create an artificial expression matrix
expr_matrix = matrix(c(runif(100*10), runif(50*10, min = 5, max = 7)), nrow = 150, byrow = TRUE)
rownames(expr_matrix) = as.character(1:150)
colnames(expr_matrix) = paste("feature", 1:10)

feature_stability_result = get_feature_stability(data_matrix = t(expr_matrix),
   feature_set = colnames(expr_matrix),
   feature_type = "feature_name",
   steps = c(5,10),
   npcs = 2,
   n_repetitions = 3,
   algorithm = 1,
   # the following parameters are used by the umap function and are not mandatory
   n_neighbors = 3,
   approx_pow = TRUE,
   n_epochs = 0,
   init = "random",
   min_dist = 0.3)
plot_feature_stability_mb_facet(feature_stability_result)
}
