% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_clusters_from_clustassess_object}
\alias{get_clusters_from_clustassess_object}
\title{Extract config-specific clusters from a ClustAssess object}
\usage{
get_clusters_from_clustassess_object(
  clustassess_object,
  feature_type = NULL,
  feature_size = NULL,
  clustering_method = NULL,
  nclusters = NULL
)
}
\arguments{
\item{clustassess_object}{Output of the \code{automatic_stability_assessment}.}

\item{feature_type}{Type of feature used for dimensionality reduction. If
\code{NULL}, it will select the first available feature.}

\item{feature_size}{Size of the feature set used for clustering. If \code{NULL},
it will select the first available feature size.}

\item{clustering_method}{Clustering method used. If \code{NULL}, it will select
the first available clustering method.}

\item{nclusters}{Number of clusters to extract. If \code{NULL}, all clusters are
returned.}
}
\value{
A list of clusters that are specific to the given configuration.
Each number of cluster will contain the list of partitions with that
specific k and the ECC value indicating the overall stability of k.
}
\description{
Given the output of the \code{automatic_stability_assessment}
function, extract the clusters that are specific to a particular
configuration of feature type, feature size, clustering method and,
optionally, the number of clusters.
}
