% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/hclustgeo.R
\name{hclustgeo}
\alias{hclustgeo}
\title{\code{hclustgeo.uniq} for several parameters alpha.}
\usage{
hclustgeo(data, D.geo, alpha)
}
\arguments{
\item{data}{a data frame with \code{n} rows and \code{p} colums where \code{n} observations are
described by \code{p} numerical variables.}

\item{D.geo}{a matrix of size \code{n} by \code{n} containing geographical distances between observations}

\item{alpha}{a vector containing all the values of the parameter alpha for which the user wishes to perform \code{hclustgeo}.}
}
\value{
{}{an object of class hclustgeo containing all the results of \code{hclustgeo.uniq} for the differents values of \code{alpha}}
}
\description{
Perform \code{hclustgeo.uniq} for several parameter alpha.
}
\examples{
###load data
#library("ClustGeo")
#data(comm303)
#base <- comm303$data.303
#Dgeo <- comm303$Dgeo.303

###perform hclustgeo for alpha=1
#res.alpha1 <- hclustgeo(data=base, D.geo=Dgeo, alpha=1)

###plot of the dendrogram
#plot(res.alpha1, choice="dendro") #we retain the partition in K=5 clusters

###plot of the map
#path.303 <- file.path(path.package("ClustGeo"), "shapes/comm303")
#ID.ind <- "INSEE_COM"
#plot(res.alpha1, choice="maps", K.range=5, path.shp=path.303, name.ind.shp=ID.ind)

###perform hclustgeo for several values of alpha
#multi.alpha <- seq(0, 1, 0.2)
#res.alpha <- hclustgeo(data=base, D.geo=Dgeo, alpha=multi.alpha)

###plot of the qualities
#plot.qual <- plot(res.alpha, choice="quality", K.range=5,
#                    path.shp=path.303, name.ind.shp=ID.ind)
}

