% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authen_NMR.R
\docType{data}
\name{authen_NMR}
\alias{authen_NMR}
\title{Authentication data set/ NMR spectra}
\format{150 observations and 2 blocks of variables.
\describe{
    \item{authen_NMR$Xz1}{spectral range from  6 to 9 ppm (300 variables)}
    \item{authen_NMR$Xz2}{spectral range from  0.5 to 2.3 ppm (180 variables)}
}}
\usage{
data(authen_NMR)
}
\description{
Discrimination between authentic and adulterated juices using 1H NMR spectroscopy.
150 samples were prepared by varying the percentage of co-fruit mixed with the fruit juice of interest. The two first characters in the row names represent this percentage. Authentic juice names begin with "00". Samples prepared with the co-fruit alone are identified by "99" (rather than 100).
}
\examples{
  data(authen_NMR)
  xlab=as.numeric(colnames(authen_NMR$Xz2))
  plot(xlab, authen_NMR$Xz2[1,], type="l", xlab="ppm",ylab="", ylim=c(14.8,15.8), 
  xlim=rev(range(xlab)))
  for (i in (1:nrow(authen_NMR$Xz2))) lines(xlab,authen_NMR$Xz2[i,])
}
\references{
Vigneau E, Thomas F (2012). Model calibration and feature selection for orange juice authentication by 1H NMR spectroscopy.Chemometrics and Intelligent Laboratory Systems, 117, 22:30.
}
\keyword{datasets}
