% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{KMeans_arma}
\alias{KMeans_arma}
\title{k-means using the Armadillo library}
\usage{
KMeans_arma(data, clusters, n_iter = 10, seed_mode = "random_subset",
  verbose = FALSE, CENTROIDS = NULL, seed = 1)
}
\arguments{
\item{data}{matrix or data frame}

\item{clusters}{the number of clusters}

\item{n_iter}{the number of clustering iterations (about 10 is typically sufficient)}

\item{seed_mode}{how the initial centroids are seeded. One of, \emph{keep_existing}, \emph{static_subset},\emph{random_subset},\emph{static_spread},\emph{random_spread}.}

\item{verbose}{either TRUE or FALSE, indicating whether progress is printed during clustering}

\item{CENTROIDS}{a matrix of initial cluster centroids. The rows of the CENTROIDS matrix should be equal to the number of clusters and the columns should be equal to the columns of the data. CENTROIDS should be used in combination with seed_mode 'keep_existing'.}

\item{seed}{integer value for random number generator (RNG)}
}
\value{
the centroids as a matrix. In case of Error it returns the error message, whereas in case of an empty centroids-matrix it returns a warning-message.
}
\description{
k-means using the Armadillo library
}
\details{
This function is an R implementation of the 'kmeans' class of the Armadillo library.
It is faster than the KMeans_rcpp function but it lacks some features. For more info see the details section of the KMeans_rcpp function.
The number of columns should be larger than the number of clusters or CENTROIDS.
If the clustering fails, the means matrix is reset and a bool set to false is returned.
The clustering will run faster on multi-core machines when OpenMP is enabled in your compiler (eg. -fopenmp in GCC)
}
\examples{

data(dietary_survey_IBS)

dat = dietary_survey_IBS[, -ncol(dietary_survey_IBS)]

dat = center_scale(dat)

km = KMeans_arma(dat, clusters = 2, n_iter = 10, "random_subset")

}
\references{
http://arma.sourceforge.net/docs.html
}

