% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{MiniBatchKmeans}
\alias{MiniBatchKmeans}
\title{Mini-batch-k-means using RcppArmadillo}
\usage{
MiniBatchKmeans(data, clusters, batch_size = 10, num_init = 1,
  max_iters = 100, init_fraction = 1, initializer = "optimal_init",
  early_stop_iter = 10, verbose = FALSE, CENTROIDS = NULL, tol = 1e-04,
  tol_optimal_init = 0.3, seed = 1)
}
\arguments{
\item{data}{matrix or data frame}

\item{clusters}{the number of clusters}

\item{batch_size}{the size of the mini batches}

\item{num_init}{number of times the algorithm will be run with different centroid seeds}

\item{max_iters}{the maximum number of clustering iterations}

\item{init_fraction}{percentage of data to use for the initialization centroids (applies if initializer is \emph{kmeans++} or \emph{optimal_init}). Should be a float number between 0.0 and 1.0.}

\item{initializer}{the method of initialization. One of, \emph{optimal_init}, \emph{quantile_init}, \emph{kmeans++} and \emph{random}. See details for more information}

\item{early_stop_iter}{continue that many iterations after calculation of the best within-cluster-sum-of-squared-error}

\item{verbose}{either TRUE or FALSE, indicating whether progress is printed during clustering}

\item{CENTROIDS}{a matrix of initial cluster centroids. The rows of the CENTROIDS matrix should be equal to the number of clusters and the columns should be equal to the columns of the data}

\item{tol}{a float number. If, in case of an iteration (iteration > 1 and iteration < max_iters) 'tol' is greater than the squared norm of the centroids, then kmeans has converged}

\item{tol_optimal_init}{tolerance value for the 'optimal_init' initializer. The higher this value is, the far appart from each other the centroids are.}

\item{seed}{integer value for random number generator (RNG)}
}
\value{
a list with the following attributes: centroids, WCSS_per_cluster, best_initialization, iters_per_initialization
}
\description{
Mini-batch-k-means using RcppArmadillo
}
\details{
This function performs k-means clustering using mini batches.

---------------initializers----------------------

\strong{optimal_init}   : this initializer adds rows of the data incrementally, while checking that they do not already exist in the centroid-matrix

\strong{quantile_init}  : initialization of centroids by using the cummulative distance between observations and by removing potential duplicates

\strong{kmeans++}       : kmeans++ initialization. Reference : http://theory.stanford.edu/~sergei/papers/kMeansPP-soda.pdf AND http://stackoverflow.com/questions/5466323/how-exactly-does-k-means-work

\strong{random}         : random selection of data rows as initial centroids
}
\examples{

data(dietary_survey_IBS)

dat = dietary_survey_IBS[, -ncol(dietary_survey_IBS)]

dat = center_scale(dat)

MbatchKm = MiniBatchKmeans(dat, clusters = 2, batch_size = 20, num_init = 5, early_stop_iter = 10)

}
\references{
http://www.eecs.tufts.edu/~dsculley/papers/fastkmeans.pdf
}
\author{
Lampros Mouselimis
}
