% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{plot_2d}
\alias{plot_2d}
\title{2-dimensional plots}
\usage{
plot_2d(data, clusters, centroids_medoids)
}
\arguments{
\item{data}{a 2-dimensional matrix or data frame}

\item{clusters}{numeric vector of length equal to the number of rows of the data, which is the result of a clustering method}

\item{centroids_medoids}{a matrix of centroids or medoids. The rows of the centroids_medoids should be equal to the length of the unique values of the clusters and
the columns should be equal to the columns of the data.}
}
\value{
a plot
}
\description{
2-dimensional plots
}
\details{
This function plots the clusters using 2-dimensional data and medoids or centroids.
}
\examples{

# data(dietary_survey_IBS)

# dat = dietary_survey_IBS[, -ncol(dietary_survey_IBS)]

# dat = center_scale(dat)

# pca_dat = stats::princomp(dat)$scores[, 1:2]

# km = KMeans_rcpp(pca_dat, clusters = 2, num_init = 5, max_iters = 100)

# plot_2d(pca_dat, km$clusters, km$centroids)

}
\author{
Lampros Mouselimis
}
