% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{predict_MBatchKMeans}
\alias{predict_MBatchKMeans}
\alias{predict.MBatchKMeans}
\title{Prediction function for Mini-Batch-k-means}
\usage{
predict_MBatchKMeans(data, CENTROIDS, fuzzy = FALSE, updated_output = FALSE)

\method{predict}{MBatchKMeans}(object, newdata, fuzzy = FALSE, ...)
}
\arguments{
\item{data}{matrix or data frame}

\item{CENTROIDS}{a matrix of initial cluster centroids. The rows of the CENTROIDS matrix should be equal to the number of clusters and the columns should equal the columns of the data.}

\item{fuzzy}{either TRUE or FALSE. If TRUE then prediction probabilities will be calculated using the distance between observations and centroids.}

\item{updated_output}{either TRUE or FALSE. If TRUE then the 'predict_MBatchKMeans' function will follow the same output object behaviour as the 'predict_KMeans' function (if fuzzy is TRUE it will return probabilities otherwise it will return the hard clusters). This parameter will be removed in version 1.4.0 because this will become the default output format.}

\item{object, newdata, ...}{arguments for the `predict` generic}
}
\value{
if fuzzy = TRUE the function returns a list with two attributes: a vector with the clusters and a matrix with cluster probabilities. Otherwise, it returns a vector with the clusters.
}
\description{
Prediction function for Mini-Batch-k-means
}
\details{
This function takes the data and the output centroids and returns the clusters.
}
\examples{

data(dietary_survey_IBS)

dat = dietary_survey_IBS[, -ncol(dietary_survey_IBS)]

dat = center_scale(dat)

MbatchKm = MiniBatchKmeans(dat, clusters = 2, batch_size = 20, num_init = 5, early_stop_iter = 10)

pr = predict_MBatchKMeans(dat, MbatchKm$centroids, fuzzy = FALSE)

}
\author{
Lampros Mouselimis
}
