% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B1MODImodel.R
\name{B1MODImodel}
\alias{B1MODImodel}
\title{Obtaining the regression value of the FBM}
\usage{
B1MODImodel(A, especie, E, EspecieMaxima, Tt)
}
\arguments{
\item{A}{Matrix of dimensions (\code{E}-1)x3 that contains all the parameters of the model except tau}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{E}{Number of bacteria available}

\item{EspecieMaxima}{Row in which the bacteria chosen as reference is in \code{especie}.This bacteria is used as reference in the alr tranformation that the model does and it is placed at the denominator of the balance)}

\item{Tt}{Number of time points available.}
}
\value{
Returns a matrix. The row i contains the regression values of the bacteria i at all time points.
}
\description{
This function calculates the value of the FBM regression, defined by:  \deqn{\mu_{it}=a_{i1}+a_{i2}\cdot\text{alr}(x_{i,(t-1)})+a_{i3}\cdot\text{Balance}(x_{i,(t-1)})\text{ for }i=1,\dots, D-1\text{ where } D \text{ is the number of bacteria}}
}
\examples{


df<-data.frame(cbind(c(0.1,0.1,0.8),c(0.2,0.1,0.7)))
E=3
EspecieMaxima=3
set.seed(724)
A=matrix(c(-2:3),2,3)
Tt=2

B1MODImodel(A,df, E, EspecieMaxima,Tt)

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2021). A Dirichlet autoregressive model for the analysis of microbiota time-series data. Complexity, 2021, 1-16.
}
