% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicsPrediction.R
\name{GraphicsPrediction}
\alias{GraphicsPrediction}
\title{Plots the time series}
\usage{
GraphicsPrediction(
  especie.All,
  names.especie,
  ExpectedValue.All,
  VarianceValue.All,
  Pred,
  Plot.Tipe,
  Detail
)
}
\arguments{
\item{especie.All}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{names.especie}{Vector with the names of the bacteria in the same order that are placed in the \code{especie} matrix.}

\item{ExpectedValue.All}{Matrix that contains at row i the expected value of the bacterial taxa i at all time points. The bacteria must be placed in the same order than in \code{especie}. This matrix must  comply: dim(ExpectedValue.All)[2]=dim(especie.All)[2]-1}

\item{VarianceValue.All}{Matrix that contains at row i the variance of the bacterial taxa i at all time points. The bacteria must be placed in the same order than in \code{especie}.This matrix must  comply: dim(VarianceValue.All)[2]=dim(especie.All)[2]-1}

\item{Pred}{Number. Indicates the time point in which we start predicting.}

\item{Plot.Tipe}{Character. If \code{Plot.Tipe==Data} the function displays a graphic of the dataset, if \code{Plot.Tipe==DataExpected} the function displays a graphic of the data and the expected values, if \code{Plot.Tipe==All} the function displays a graphic with the data, the expected values and the variance.If  \code{Plot.Tipe==Var} the function returns the boxplot of the variance at each time point and the variance of each bacteria. If  \code{Plot.Tipe==OnlyVar} the function returns the boxplots of the variance at each time points.}

\item{Detail}{Character. If \code{Detail==no} the graphic obtained when \code{Plot.Tipe==DataExpected} and \code{Plot.Tipe==All} will have the same y axis for all the taxa. If \code{Detail==yes} these functions will have different y axis.}
}
\value{
Returns the indicated plots with a vertical line when the time point is equal to Pred-1, in Pred the prediction has started.
}
\description{
This function takes into account the data used to estimate  and the data used to predict.
}
\examples{


names.especie=c("Bact1", "Bact2", "Bact3")
especie.All=cbind(c(0.5,0.3,0.2),
                c(0.6,0.3,0.1),
                c(0.4,0.1,0.5),
                c(0.4,0.1,0.5),
                c(0.4,0.1,0.5),
                c(0.4,0.1,0.5))
ExpectedValue.All=especie.All[,-1]+0.1
VarianceValue.All=matrix(c(runif(15,0.001,0.004)), 3,5)
Pred=4

GraphicsPrediction(especie.All,
                  names.especie,
                  ExpectedValue.All,
                  VarianceValue.All ,
                  Pred,
                  "Data",
                  "no")

GraphicsPrediction(especie.All,
                 names.especie,
                 ExpectedValue.All,
                 VarianceValue.All ,
                 Pred,
                 "DataExpected",
                 "no")

GraphicsPrediction(especie.All,
                 names.especie,
                 ExpectedValue.All,
                 VarianceValue.All ,
                 Pred,
                 "All",
                 "no")

GraphicsPrediction(especie.All,
                 names.especie,
                 ExpectedValue.All,
                 VarianceValue.All ,
                 Pred,
                 "Var",
                 "no")

GraphicsPrediction(especie.All,
                 names.especie,
                 ExpectedValue.All,
                 VarianceValue.All ,
                 Pred,
                 "OnlyVar",
                 "no")


}
