% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObtainigValuePB.R
\name{ObtainigValuePB}
\alias{ObtainigValuePB}
\title{Obtaining the principal balances values}
\usage{
ObtainigValuePB(Num, Dem, especie, Tt)
}
\arguments{
\item{Num}{List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the numerator of the principal balance i are placed.}

\item{Dem}{List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the denominator of the principal balance i are placed.}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{Tt}{Number of time points available}
}
\value{
Returns a matrix where the row i has the value of the principal balance at all time points. The principal balance of the row i has at its numerator the bacteria placed in the rows \code{Num[[i]]} of the \code{especie}. The principal balance of the row i has at its denominator the bacteria placed in the rows \code{Dem[[i]]} of the \code{especie}.
}
\description{
Calculates the value of the principal balances (Martín-Fernández et al, 2018) at all time points.
}
\examples{

set.seed(314)
esp2=t(gtools::rdirichlet(n=6, c(1,1,5,1,1)))

Num2<-list(3,c(3,5),1,c(3,5,4))
Dem2<-list(5,4,2,c(1,2))

ObtainigValuePB(Num2,Dem2,esp2,6)

}
\references{
\itemize{
\item Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
\item Martín-Fernández, J. A., Pawlowsky-Glahn, V., Egozcue, J. J., & Tolosona-Delgado, R. (2018). Advances in principal balances for compositional data. Mathematical Geosciences, 50, 273-298.
}
}
