% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotDendogram.R
\name{PlotDendogram}
\alias{PlotDendogram}
\title{Plotting a dendogram}
\usage{
PlotDendogram(especie, names)
}
\arguments{
\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{names}{Vector with the names of the bacteria in the same order that are written in \code{especie}.}
}
\value{
Returns a list with: the dendogram.

\itemize{
  \item Num: List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the numerator of the principal balance i are placed.
  \item Dem:  List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the denominator of the principal balance i are placed.
  \item dendogram:  Plots the dendogram.
  }
}
\description{
Plots the dendogram obtained using the  Ward’s method for obtaining the principal balances. The process follow in this function is explained  in Section 3.1 of (Creus-Martí et al, 2022)
}
\examples{

names2=c("Bact1","Bact2","Bact3","Bact4","Bact5")
set.seed(314)
esp2=t(gtools::rdirichlet(n=6, c(1,1,5,1,1)))


PlotDendogram(esp2,names2)

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
}
