% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{moments}
\alias{moments}
\title{Numerical estimation of moments}
\usage{
moments(dist, distarg, p0 = 0, raw = T, central = T, coef = T,
  distbounds = c(-Inf, Inf), order = 1:4)
}
\arguments{
\item{dist}{distribution}

\item{distarg}{list of distribution arguments}

\item{p0}{probability zero}

\item{raw}{logical - calculate raw moments?}

\item{central}{logical - calculate central moments?}

\item{coef}{logical - calculate coeffitients (coeffitient of variation, skweness and kurtosis)?}

\item{distbounds}{distribution bounds (default set to c(-Inf, Inf))}

\item{order}{vector of integers - raw moment orders}
}
\description{
Uses numerical integration to caclulate the theoretical raw or central moments of the specified distribution
}
\examples{

library(CoSMoS)

## Normal Distribution
moments('norm', list(mean = 2, sd = 1))

## Pareto type II
scale <- 1
shape <- .2

moments(dist = 'paretoII',
        distarg = list(shape = shape,
                       scale = scale))

}
\keyword{moment}
\keyword{moments,}
