% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stcs.r
\name{stcfgneiting14}
\alias{stcfgneiting14}
\title{Gneiting-14 SpatioTemporal Correlation Structure}
\usage{
stcfgneiting14(t, s, a, c, alpha, beta, gamma, tau)
}
\arguments{
\item{t}{time lag}

\item{s}{spatial lag (distance)}

\item{a}{nonnegative scaling parameter of time}

\item{c}{nonnegative scaling parameter of space}

\item{alpha}{smoothness parameter of time. Valid range: \eqn{(0,1]}}

\item{beta}{space-time interaction parameter. Valid range: \eqn{[0,1]}}

\item{gamma}{smoothness parameter of space. Valid range: \eqn{(0,1]}}

\item{tau}{space-time interaction parameter. Valid range: \eqn{\ge 1} (for 2-dimensional fields)}
}
\description{
Provides spatiotemporal correlation structure function proposed by \href{https://doi.org/10.1198/016214502760047113}{Gneiting (2002)} (Eq.14 at p. 593)
}
\examples{

library(CoSMoS)
library(plotly)

## specify grid of spatial and temporal lags
d <- 31
st <- expand.grid(0:(d - 1),
                  0:(d - 1))

## get the STCS
g14 <- stcfgneiting14(t = st[, 1],
                      s = st[, 2],
                      a = 1/50,
                      c = 1/10,
                      alpha = 1,
                      beta = 1,
                      gamma = 0.5,
                      tau = 1)

## visualize the STCS

g14.m <- matrix(g14,
                nrow = d)

plot_ly(z = ~g14.m) \%>\%
    add_surface() \%>\%
    layout(
        scene = list(
            xaxis = list(title = "Time lag"),
            yaxis = list(title = "Distance"),
            zaxis = list(title = "STCF")
        )
    ) \%>\%
    hide_colorbar()

}
