% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stcs.r
\name{stcfgneiting16}
\alias{stcfgneiting16}
\title{Gneiting-16 SpatioTemporal Correlation Structure}
\usage{
stcfgneiting16(t, s, a, c, alpha, beta, nu, tau)
}
\arguments{
\item{t}{time lag}

\item{s}{spatial lag (distance)}

\item{a}{nonnegative scaling parameter of time}

\item{c}{nonnegative scaling parameter of space}

\item{alpha}{smoothness parameter of time. Valid range: \eqn{(0,1]}}

\item{beta}{space-time interaction parameter. Valid range: \eqn{[0,1]}}

\item{nu}{smoothness parameter of space. Valid range: \eqn{>0}}

\item{tau}{space-time interaction parameter. Valid range: \eqn{\ge 1} (for 2-dimensional fields)}
}
\description{
Provides spatiotemporal correlation structure function proposed by
Gneiting (2002; Eq.16 at p. 594).
}
\examples{

library(plot3D)

## specify grid of spatial and temporal lags
d <- 31
st <- expand.grid(0:(d - 1),
                  0:(d - 1))

## get the STCS
g16 <- stcfgneiting16(t = st[, 1],
                      s = st[, 2],
                      a = 1/50,
                      c = 1/10,
                      alpha = 1,
                      beta = 1,
                      nu = 0.5, tau = 1)

## visualize the STCS

g16.m <- matrix(g16,
                nrow = d)

persp3D(z = g16.m, x = 1: nrow(g16.m), y = 1:ncol(g16.m),
        expand = 1, main = "", scale = TRUE, facets = TRUE,
        xlab="Time lag", ylab = "Distance", zlab = "STCF",
        colkey = list(side = 4, length = 0.5), phi = 20, theta = 120,
        resfac = 5,  col= gg2.col(100))

}
\references{
Gneiting, T. (2002). Nonseparable, Stationary Covariance Functions
for Space-Time Data, Journal of the American Statistical Association,
97:458, 590-600, \doi{10.1198/016214502760047113}
}
