% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaGetPub.R
\name{ctmaGetPub}
\alias{ctmaGetPub}
\title{ctmaGetPub}
\usage{
ctmaGetPub(authorList = NULL, flush = FALSE, yearsToExclude = NULL)
}
\arguments{
\item{authorList}{list of authors and googe scholar addresses}

\item{flush}{if TRUE, the cache will be cleared and the data reloaded from Google.}

\item{yearsToExclude}{the years to be excluded (default = current year)}
}
\value{
list with (cumulative) frequencies and (cumulative) citations in google scholar
}
\description{
Retrieves publication and citation information from google scholar based on the supplied author names and their google ID (user)
}
\note{
Set flush=TRUE only if retrieving is necessary (e.g., first retrieval on a day)
}
\examples{
\donttest{
pubList_8 <- ctmaGetPub(authorList = list( c("J; de Jonge",
              "https://scholar.google.de/citations?hl=de&user=0q27IckAAAAJ"),
              c("Arnold B.; Bakker", "user=FTl3bwUAAAAJ"),
              c("Evangelia; Demerouti", "user=9mj5LvMAAAAJ"),
              c("Joachim; Stoeber", "user=T9xdVusAAAAJ"),
              c("Claude; Fernet", "user=KwzjP4sAAAAJ"),
              c("Frederic; Guay", "user=99vnhX4AAAAJ"),
              c("Caroline; Senecal", "user=64ArFWQAAAAJ"),
              c("StÃ©phanie; Austin", "user=PPyTI7EAAAAJ")),
              flush=FALSE)
summary(pubList_8)
}

}
