% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaModDrift.R
\name{ctmaModDrift}
\alias{ctmaModDrift}
\title{ctmaModDrift}
\usage{
ctmaModDrift(
  CoTiMAFit = NULL,
  ctStanFit = NULL,
  transform = NULL,
  modValues = NULL,
  mod.type = NULL,
  mod.number = 1,
  scaleTime = 1
)
}
\arguments{
\item{CoTiMAFit}{A CoTiMA Fitobject.}

\item{ctStanFit}{A ctStanFit Fitobject.}

\item{transform}{A string vector containing the desired transformations. Usually NULL.
Could be used replace transforms contained in ctStanFit$pars.}

\item{modValues}{A vector containing the desired values for the moderator. Usually -2:2.
Could be used replace possible categorical moderator values contained in CoTiMAFit.}

\item{mod.type}{A string vector containing either "cat" or "cont".
Could be used for older CoTiMA fit objects where this information is not included. Use with car.}

\item{mod.number}{The number of the moderator that should be used if multiple moderators are supplied}

\item{scaleTime}{A scalar used to rescale the drift matrix. default = 1.}
}
\value{
A list of drift matrices for different moderator values.
}
\description{
Uses raw estimates of drift and TI effects to compute a set of different drift matrices for different moderator values
}
\examples{
\dontrun{
modDriftMatrices <- ctmaModDrift(CoTiMAFitObject)
}

}
