% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaAllInvFit.R
\name{ctmaAllInvFit}
\alias{ctmaAllInvFit}
\title{ctmaAllInvFit}
\usage{
ctmaAllInvFit(
  ctmaInitFit = NULL,
  activeDirectory = NULL,
  activateRPB = FALSE,
  digits = 4,
  drift = drift,
  coresToUse = c(1),
  n.manifest = 0,
  indVarying = FALSE,
  scaleTime = NULL,
  optimize = TRUE,
  nopriors = TRUE,
  priors = FALSE,
  finishsamples = NULL,
  iter = NULL,
  chains = NULL,
  verbose = NULL,
  loadAllInvFit = c(),
  saveAllInvFit = c(),
  silentOverwrite = FALSE,
  customPar = FALSE,
  T0means = 0,
  manifestMeans = 0,
  CoTiMAStanctArgs = NULL,
  lambda = NULL,
  manifestVars = NULL,
  indVaryingT0 = TRUE
)
}
\arguments{
\item{ctmaInitFit}{ctmaInitFit}

\item{activeDirectory}{activeDirectory}

\item{activateRPB}{activateRPB}

\item{digits}{digits}

\item{drift}{Labels for drift effects. Have to be either of the type V1toV2 or 0 for effects to be excluded, which is usually not recommended)}

\item{coresToUse}{coresToUse}

\item{n.manifest}{Number of manifest variables of the model (if left empty it will assumed to be identical with n.latent).}

\item{indVarying}{Allows ct intercepts to vary at the individual level (random effects model, accounts for unobserved heterogeneity)}

\item{scaleTime}{scaleTime}

\item{optimize}{optimize}

\item{nopriors}{nopriors (TRUE, but deprecated)}

\item{priors}{priors (FALSE)}

\item{finishsamples}{finishsamples}

\item{iter}{iter}

\item{chains}{chains}

\item{verbose}{verbose}

\item{loadAllInvFit}{loadAllInvFit}

\item{saveAllInvFit}{saveAllInvFit}

\item{silentOverwrite}{silentOverwrite}

\item{customPar}{logical. If set TRUE (default) leverages the first pass using priors and ensure that the drift diagonal cannot easily go too negative (helps since ctsem > 3.4)}

\item{T0means}{Default 0 (assuming standardized variables). Can be assigned labels to estimate them freely.}

\item{manifestMeans}{Default 0 (assuming standardized variables). Can be assigned labels to estimate them freely.}

\item{CoTiMAStanctArgs}{parameters that can be set to improve model fitting of the \code{\link{ctStanFit}} Function}

\item{lambda}{R-type matrix with pattern of fixed (=1) or free (any string) loadings.}

\item{manifestVars}{define the error variances of the manifests with a single time point using R-type lower triangular matrix with nrow=n.manifest & ncol=n.manifest.}

\item{indVaryingT0}{Allows ct intercepts to vary at the individual level (random effects model, accounts for unobserved heterogeneity)}
}
\value{
returns a fitted CoTiMA object, in which all drift parameters, Time 0 variances and covariances, and diffusion parameters were set invariant across primary studies
}
\description{
#' @description Fit a CoTiMA model with all params (drift, T0var, diffusion) invariant across primary studies
}
