% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getICD10StandardCodes.R
\name{getICD10StandardCodes}
\alias{getICD10StandardCodes}
\title{Get corresponding standard codes for ICD-10 chapters and sub-chapters}
\usage{
getICD10StandardCodes(cdm, level = c("ICD10 Chapter", "ICD10 SubChapter"))
}
\arguments{
\item{cdm}{cdm_reference via CDMConnector}

\item{level}{Can be either "ICD10 Chapter" or "ICD10 SubChapter"}
}
\value{
A named list, with each element containing the corresponding
standard codes (and descendants) of ICD chapters and sub-chapters
}
\description{
Get corresponding standard codes for ICD-10 chapters and sub-chapters
}
\examples{
cdm <- mockVocabRef()
getICD10StandardCodes(cdm = cdm, level = c(
  "ICD10 Chapter",
  "ICD10 SubChapter"
))
DBI::dbDisconnect(attr(cdm, "dbcon"), shutdown = TRUE)
}
