% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCodeUse.R
\name{summariseCohortCodeUse}
\alias{summariseCohortCodeUse}
\title{Summarise code use among a cohort in the cdm reference}
\usage{
summariseCohortCodeUse(
  x,
  cdm,
  cohortTable,
  cohortId = NULL,
  timing = "any",
  countBy = c("record", "person"),
  byConcept = TRUE,
  byYear = FALSE,
  bySex = FALSE,
  ageGroup = NULL,
  minCellCount = 5
)
}
\arguments{
\item{x}{Vector of concept IDs}

\item{cdm}{cdm_reference via CDMConnector::cdm_from_con()}

\item{cohortTable}{A cohort table from the cdm reference.}

\item{cohortId}{A vector of cohort IDs to include}

\item{timing}{When to assess the code use relative cohort dates. This can
be "any"(code use any time by individuals in the cohort) or  "entry" (code
use on individuals' cohort start date).}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts}

\item{byConcept}{TRUE or FALSE. If TRUE code use will be summarised by}

\item{byYear}{TRUE or FALSE. If TRUE code use will be summarised by year.}

\item{bySex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{If not NULL, a list of ageGroup vectors of length two.}

\item{minCellCount}{The minimum number of counts to reported, below which
results will be suppressed. If 0, all results will be reported.}
}
\value{
A tibble with results overall and, if specified, by strata
}
\description{
Summarise code use among a cohort in the cdm reference
}
