% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntersectCohorts.R
\name{intersectCohorts}
\alias{intersectCohorts}
\title{Intersect cohort(s)}
\usage{
intersectCohorts(
  connectionDetails = NULL,
  connection = NULL,
  sourceCohortDatabaseSchema = NULL,
  sourceCohortTable,
  targetCohortDatabaseSchema = NULL,
  targetCohortTable,
  cohortIds,
  newCohortId,
  purgeConflicts = FALSE,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema")
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{sourceCohortDatabaseSchema}{Schema name where your source cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{sourceCohortTable}{The name of the source cohort table.}

\item{targetCohortDatabaseSchema}{Schema name where your target cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{targetCohortTable}{The name of the target cohort table.}

\item{cohortIds}{A vector of one or more Cohort Ids.}

\item{newCohortId}{The cohort id of the output cohort.}

\item{purgeConflicts}{If there are conflicts in the target cohort table i.e. the target cohort table
already has records with newCohortId, do you want to purge and replace them
with transformed. By default - it will not be replaced, and an error message is thrown.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}
}
\value{
Nothing is returned
}
\description{
Find the common cohort period for persons present in all the cohorts. Note: if
subject is not found in any of the cohorts, then they will not
be in the final cohort.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
