% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExecuteCohortPathways.R
\name{executeCohortPathways}
\alias{executeCohortPathways}
\title{Execute cohort pathway analysis.}
\usage{
executeCohortPathways(
  connectionDetails = NULL,
  connection = NULL,
  cohortDatabaseSchema,
  cohortTableName = "cohort",
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  targetCohortIds,
  eventCohortIds,
  minCellCount = 5,
  allowRepeats = FALSE,
  maxDepth = 5,
  collapseWindow = 30
)
}
\arguments{
\item{connectionDetails}{An object of type connectionDetails as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if connectionDetails
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cohortTableName}{The name of the cohort table.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}

\item{targetCohortIds}{A vector of one or more Cohort Ids corresponding to target cohort (s).}

\item{eventCohortIds}{A vector of one or more Cohort Ids corresponding to event cohort (s).}

\item{minCellCount}{(Default = 5) The minimum cell count for fields contains person counts or fractions.}

\item{allowRepeats}{(Default = FALSE) Allow cohort events/combos to appear multiple times in the same pathway.}

\item{maxDepth}{(Default = 5) Maximum number of steps in a given pathway to be included in the sunburst plot}

\item{collapseWindow}{(Default = 30) Any dates found within the specified collapse days will
be reassigned the earliest date. Collapsing dates reduces pathway
variation, leading to a reduction in 'noise' in the result.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{                 An array of Data Frame objects.
}\if{html}{\out{</div>}}
}
\description{
Runs the cohort pathways on all instantiated combinations of target and event cohorts.
Assumes the cohorts have already been instantiated.
}
\examples{
\dontrun{

executeCohortPathways(
  connectionDetails = connectionDetails,
  cohorts = cohorts,
  cohortDatabaseSchema = "results"
)
}

}
