% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_trial.R
\name{simulate_trial}
\alias{simulate_trial}
\title{Simulates the cohort trial.}
\usage{
simulate_trial(
  n_int = 50,
  n_fin = 100,
  cohorts_start = 1,
  rr_comb,
  rr_mono,
  rr_back,
  rr_plac,
  rr_transform,
  random_type = NULL,
  trial_struc = "all_plac",
  random = FALSE,
  prob_comb_rr = NULL,
  prob_mono_rr = NULL,
  prob_back_rr = NULL,
  prob_plac_rr = NULL,
  prob_rr_transform = prob_rr_transform,
  stage_data = TRUE,
  cohort_random = NULL,
  cohorts_max = 4,
  sr_drugs_pos = 1,
  sr_pats = cohorts_max * (n_fin + 3 * cohorts_max),
  sr_first_pos = FALSE,
  target_rr = c(0, 0, 1),
  cohort_offset = 0,
  sharing_type = "all",
  safety_prob = 0,
  ...
)
}
\arguments{
\item{n_int}{Sample size per cohort to conduct interim analysis}

\item{n_fin}{Sample size per cohort at final}

\item{cohorts_start}{Number of cohorts to start the platform with}

\item{rr_comb}{Response rates of combination therapies}

\item{rr_mono}{Response rate of mono therapies}

\item{rr_back}{Response rates of backbone arms}

\item{rr_plac}{Response rate of the placebo}

\item{rr_transform}{Function transforming all the above response rates to a vector of four probabilities for the multinomial simulation
First element is probability of both failures. Second element is probability of biomarker success and histology failure.
Third element is probability of biomarker failure and histology success. Fourth element is probability of both success.}

\item{random_type}{How should the response rates be drawn randomly? Options are:

                            "absolute": Specify absolute response rates that will be drawn with a certain probability

                            "risk_difference": Specify absolute response rates for placebo which will be drawn randomly, plus specify vectors
                            for absolute treatment effects of mono therapies over placebo and for combo over the mono therapies.

                            "risk_ratio": Specify absolute response rates for placebo which will be drawn randomly, plus specify vectors
                            for relative treatment effects of mono therapies over placebo and for combo over the mono therapies.

                            "odds_ratios": Specify response rate for placebo, specify odds-ratios for mono therapies (via rr_back and rr_mono)
                            and respective probabilities. On top, specify interaction for the combination therapy via rr_comb with prob_rr_comb.
                            Set: odds_combo = odds_plac * or_mono1 * or_mono2 * rr_comb.
                            If rr_comb > 1 -> synergistic, if rr_comb = 1 -> additive. If rr_comb < 1 -> antagonistic.
                            Default is "NULL".}

\item{trial_struc}{Trial Structure:
                            "all_plac" = all cohorts have placebo arm

                            "no_plac" = no cohort has placebo arm

                            "stop_post_mono" = all cohorts start with placebo arm, but after first mono has been declared successful,
                            newly enrolled cohorts have no more placebo

                            "stop_post_back" = all cohorts start with placebo arm, but after first backbone has been declared successful,
                            newly enrolled cohorts have no more placebo}

\item{random}{Should the response rates of the arms be randomly drawn from rr_exp? Default is FALSE.}

\item{prob_comb_rr}{If random == TRUE, what are the probabilities with which the elements of rr_comb should be drawn?}

\item{prob_mono_rr}{If random == TRUE, what are the probabilities with which the elements of rr_mono should be drawn?}

\item{prob_back_rr}{If random == TRUE, what are the probabilities with which the elements of rr_back should be drawn?}

\item{prob_plac_rr}{If random == TRUE, what are the probabilities with which the elements of rr_plac should be drawn?}

\item{prob_rr_transform}{If random == TRUE, what are the probabilities with which the elements of rr_transform should be drawn?}

\item{stage_data}{Should individual stage data be passed along? Default is TRUE}

\item{cohort_random}{If not NULL, indicates that new arms/cohorts should be randomly started.
For every patient, there is a cohort_random probability that a new cohort will be started.}

\item{cohorts_max}{Maximum number of cohorts that are allowed to be added throughout the trial}

\item{sr_drugs_pos}{Stopping rule for successful experimental arms; Default = 1}

\item{sr_pats}{Stopping rule for total number of patients; Default = cohorts_max * n_fin + error term based on randomization}

\item{sr_first_pos}{Stopping rule for first successful cohort; if TRUE, after first cohort was found to be successful, no further cohorts will be included
but cohorts will finish evaluating, unless other stopping rules reached prior. Default is FALSE.}

\item{target_rr}{What is target to declare a combo a positive? Vector of length 3 giving 1) the threshold by which
the combo needs to be better than the monos and 2) the threshold by which the monos need to be better than the placebo.
The third element of the vector specifies the relation, choices are 1=="risk-difference", 2=="risk-ratio" and 3=="odds-ratio".
By default: c(0,0, "risk-difference").}

\item{cohort_offset}{Minimum number of patients between adding new cohorts}

\item{sharing_type}{Which backbone and placebo data should be used for arm comparisons; Default is "all". Another option is "concurrent" or "dynamic" or "cohort".}

\item{safety_prob}{Probability for a safety stop after every patient}

\item{...}{Further arguments to be passed to decision function, such as decision making criteria}
}
\value{
List containing: Responses and patients on experimental and control arm, total treatment successes and failures and final p-value
}
\description{
Disclaimer: EU-PEARL (EU Patient-cEntric clinicAl tRial pLatforms) project has received funding from the Innovative Medicines Initiative (IMI) 2 Joint Undertaking (JU) under grant agreement No 853966. This Joint Undertaking receives support from the European Unions Horizon 2020 research and innovation program and EFPIA and Childrens Tumor Foundation, Global Alliance for TB Drug Development non-profit organization, Springworks Therapeutics Inc. This publication reflects the authors views. Neither IMI nor the European Union, EFPIA, or any Associated Partners are responsible for any use that may be made of the information contained herein. The research of Elias Laurin Meyer was funded until 11/2020 by Novartis through the University and not at an individual level.
}
\examples{

random <- TRUE

rr_comb <- c(0.25, 0.35, 0.4)
prob_comb_rr <- c(0.4, 0.4, 0.2)
rr_mono <- c(0.15, 0.20, 0.25)
prob_mono_rr <- c(0.2, 0.4, 0.4)
rr_back <- c(0.20, 0.25, 0.30)
prob_back_rr <- c(0.3, 0.4, 0.3)
rr_plac <- c(0.10, 0.12, 0.14)
prob_plac_rr <- c(0.25, 0.5, 0.25)


cohorts_max <- 4
trial_struc <- "stop_post_back"
safety_prob <- 0
sharing_type <- "concurrent"
sr_drugs_pos <- 4
sr_first_pos <- TRUE
n_int <- 50
n_fin <- 100
stage_data <- TRUE
cohort_random <- 0.05
target_rr <- c(0,0,1)
cohort_offset <- 5
random_type <- "risk_difference"

# Vergleich Combo vs Mono
Bayes_Sup1 <- matrix(nrow = 3, ncol = 3)
Bayes_Sup1[1,] <- c(0.00, 0.90, 1.00)
Bayes_Sup1[2,] <- c(0.05, 0.65, 1.00)
Bayes_Sup1[3,] <- c(0.10, 0.50, 1.00)
# Vergleich Combo vs Backbone
Bayes_Sup2 <- matrix(nrow = 3, ncol = 3)
Bayes_Sup2[1,] <- c(0.05, 0.80, 1.00)
Bayes_Sup2[2,] <- c(NA, NA, NA)
Bayes_Sup2[3,] <- c(NA, NA, NA)
# Vergleich Mono vs Placebo
Bayes_Sup3 <- matrix(nrow = 3, ncol = 3)
Bayes_Sup3[1,] <- c(0.00, 0.90, 1.00)
Bayes_Sup3[2,] <- c(0.05, 0.65, 1.00)
Bayes_Sup3[3,] <- c(NA, NA, NA)
Bayes_Sup4 <- matrix(nrow = 3, ncol = 3)
Bayes_Sup4[1,] <- c(0.00, 0.90, 1.00)
Bayes_Sup4[2,] <- c(0.05, 0.65, 1.00)
Bayes_Sup4[3,] <- c(NA, NA, NA)
Bayes_Sup <- list(list(Bayes_Sup1, Bayes_Sup2, Bayes_Sup3, Bayes_Sup4),
             list(Bayes_Sup1, Bayes_Sup2, Bayes_Sup3, Bayes_Sup4))


}
