% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSurvival.R
\name{estimateSingleEventSurvival}
\alias{estimateSingleEventSurvival}
\title{Estimate survival for a given event of interest using cohorts in the OMOP Common Data Model}
\usage{
estimateSingleEventSurvival(
  cdm,
  targetCohortTable,
  targetCohortId = NULL,
  outcomeCohortTable,
  outcomeCohortId = NULL,
  outcomeDateVariable = "cohort_start_date",
  censorOnCohortExit = FALSE,
  censorOnDate = NULL,
  followUpDays = Inf,
  strata = NULL,
  timeGap = c(1, 7, 30, 365),
  minCellCount = 5,
  returnParticipants = FALSE
)
}
\arguments{
\item{cdm}{CDM reference}

\item{targetCohortTable}{targetCohortTable}

\item{targetCohortId}{targetCohortId}

\item{outcomeCohortTable}{The outcome cohort table of interest.}

\item{outcomeCohortId}{ID of event cohorts to include. Only one outcome
(and so one ID) can be considered.}

\item{outcomeDateVariable}{Variable containing date of outcome event}

\item{censorOnCohortExit}{If TRUE, an individual's follow up will be
censored at their cohort exit}

\item{censorOnDate}{if not NULL, an individual's follow up will be censored
at the given date}

\item{followUpDays}{Number of days to follow up individuals (lower bound 1,
upper bound Inf)}

\item{strata}{strata}

\item{timeGap}{Days between time points for which to report survival
estimates. First day will be day zero with risk estimates provided
for times up to the end of follow-up, with a gap in days equivalent
to timeGap.}

\item{minCellCount}{The minimum number of events to reported, below which
results will be obscured. If 0, all results will be reported.}

\item{returnParticipants}{Either TRUE or FALSE. If TRUE, references to
participants from the analysis will be returned allowing for further
analysis.}
}
\value{
tibble with survival information for desired cohort, including:
time, people at risk, survival probability, cumulative incidence,
95 CIs, strata and outcome. A tibble with the number of events is
outputted as an attribute of the output
}
\description{
Estimate survival for a given event of interest using cohorts in the OMOP Common Data Model
}
\examples{
\donttest{
cdm <- mockMGUS2cdm()
surv <- estimateSingleEventSurvival(
  cdm = cdm,
  targetCohortTable = "mgus_diagnosis",
  targetCohortId = 1,
  outcomeCohortTable = "death_cohort",
  outcomeCohortId = 1,
  timeGap = 7
)
}

}
