% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LogLik_Cox_PH_Omnibus}
\alias{LogLik_Cox_PH_Omnibus}
\title{Primary Cox PH regression with multiple starting points and optional combinations of null, stratification, competing risks, multiplicative log-linear model, and no derivative calculation.
\code{LogLik_Cox_PH_Omnibus} Performs the calls to calculation functions, Structures the Cox PH regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives}
\usage{
LogLik_Cox_PH_Omnibus(
  Term_n,
  tform,
  a_ns,
  x_all,
  dfc,
  fir,
  der_iden,
  modelform,
  lr,
  maxiters,
  guesses,
  halfmax,
  epsilon,
  dbeta_cap,
  abs_max,
  dose_abs_max,
  deriv_epsilon,
  df_groups,
  tu,
  double_step,
  change_all,
  verbose,
  debugging,
  KeepConstant,
  term_tot,
  ties_method,
  nthreads,
  STRATA_vals,
  cens_weight,
  cens_thres,
  strata_bool,
  basic_bool,
  null_bool,
  CR_bool,
  single_bool,
  gmix_theta,
  gmix_term
)
}
\arguments{
\item{Term_n}{Term numbers}

\item{tform}{subterm types}

\item{a_ns}{matrix of starting values}

\item{x_all}{covariate matrix}

\item{dfc}{vector matching subterm number to matrix column}

\item{fir}{st term number}

\item{der_iden}{subterm number for derivative tests}

\item{modelform}{string model identifier}

\item{lr}{learning rate for newton step toward 0 derivative}

\item{maxiters}{list of maximum number of iterations}

\item{guesses}{number of initial}

\item{halfmax}{maximum number of half steps}

\item{epsilon}{minimum acceptable maximum parameter change}

\item{dbeta_cap}{learning rate for newton step toward 0 log-likelihood}

\item{abs_max}{Maximum allowed parameter change}

\item{dose_abs_max}{Maximum allowed threshold parameter change}

\item{deriv_epsilon}{threshold for near-zero derivative}

\item{df_groups}{matrix with time and event information}

\item{tu}{Event time vector}

\item{double_step}{controls the step calculation, 0 for independent changes, 1 for solving b=Ax with complete matrices}

\item{change_all}{boolean if every parameter is being updated}

\item{verbose}{boolean for additional printing}

\item{debugging}{additional boolean for verbosity in testing}

\item{KeepConstant}{binary vector to identify constant parameters}

\item{term_tot}{total number of terms}

\item{ties_method}{Ties method}

\item{nthreads}{number of threads available}

\item{STRATA_vals}{vector of strata identifier values}

\item{cens_weight}{vector of censoring weights}

\item{cens_thres}{threshold to add competing event to risk group}

\item{strata_bool}{boolean for stratification}

\item{basic_bool}{boolean for multiplicative log-linear model}

\item{null_bool}{boolean for null model}

\item{CR_bool}{boolean for competing risks}

\item{single_bool}{boolean for single calculation without derivatives}

\item{gmix_theta}{theta value for geometric-mixture model}

\item{gmix_term}{list of 0/1 to identify which terms to set as Relative Risk (0) or Excess Risk (1)}
}
\value{
List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
}
\description{
Primary Cox PH regression with multiple starting points and optional combinations of null, stratification, competing risks, multiplicative log-linear model, and no derivative calculation.
\code{LogLik_Cox_PH_Omnibus} Performs the calls to calculation functions, Structures the Cox PH regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
}
