# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Utility function to define risk groups
#'
#' \code{Make_Groups} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
Make_Groups <- function(ntime, df_m, RiskFail, RiskGroup, tu, nthreads, debugging) {
    invisible(.Call(`_Colossus_Make_Groups`, ntime, df_m, RiskFail, RiskGroup, tu, nthreads, debugging))
}

#' Utility function to define risk groups with competing risks
#'
#' \code{Make_Groups_CR} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group, adds rows with event = 2 past the event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
Make_Groups_CR <- function(ntime, df_m, RiskFail, RiskGroup, tu, cens_weight, nthreads, debugging) {
    invisible(.Call(`_Colossus_Make_Groups_CR`, ntime, df_m, RiskFail, RiskGroup, tu, cens_weight, nthreads, debugging))
}

#' Utility function to define risk groups with STRATA
#'
#' \code{Make_Groups_STRATA} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
Make_Groups_STRATA <- function(ntime, df_m, RiskFail, RiskGroup, tu, nthreads, debugging, STRATA_vals) {
    invisible(.Call(`_Colossus_Make_Groups_STRATA`, ntime, df_m, RiskFail, RiskGroup, tu, nthreads, debugging, STRATA_vals))
}

#' Utility function to define risk groups with STRATA and competing risks
#'
#' \code{Make_Groups_STRATA_CR} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group, adds competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
#' @noRd
#'
Make_Groups_STRATA_CR <- function(ntime, df_m, RiskFail, RiskGroup, tu, nthreads, debugging, STRATA_vals, cens_weight) {
    invisible(.Call(`_Colossus_Make_Groups_STRATA_CR`, ntime, df_m, RiskFail, RiskGroup, tu, nthreads, debugging, STRATA_vals, cens_weight))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation
#'
#' \code{Calculate_Sides} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides <- function(RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, nthreads, debugging, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides`, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, nthreads, debugging, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation
#'
#' \code{Calculate_Sides_CR} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_CR <- function(RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, nthreads, debugging, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_CR`, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, nthreads, debugging, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation
#'
#' \code{Calculate_Sides_CR_SINGLE} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_CR_SINGLE <- function(RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, cens_weight, nthreads, debugging, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_CR_SINGLE`, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, cens_weight, nthreads, debugging, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation. but not derivatives
#'
#' \code{Calculate_Sides_Single} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_Single <- function(RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, nthreads, debugging) {
    invisible(.Call(`_Colossus_Calculate_Sides_Single`, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, nthreads, debugging))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with STRATA
#'
#' \code{Calculate_Sides_STRATA} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_STRATA <- function(RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, nthreads, debugging, STRATA_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_STRATA`, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, nthreads, debugging, STRATA_vals, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with STRATA and without derivative
#'
#' \code{Calculate_Sides_STRATA_Single} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group but not derivatives
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_STRATA_Single <- function(RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, nthreads, debugging, STRATA_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_STRATA_Single`, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, nthreads, debugging, STRATA_vals, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with STRATA and competing risks
#'
#' \code{Calculate_Sides_STRATA_CR} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group and competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_STRATA_CR <- function(RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, nthreads, debugging, STRATA_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_STRATA_CR`, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, nthreads, debugging, STRATA_vals, KeepConstant))
}

#' Utility function to calculate repeated values used in Cox Log-Likelihood calculation with STRATA and without derivative and with competing risks
#'
#' \code{Calculate_Sides_STRATA_Single_CR} Called to update repeated sum calculations, Uses list of event rows and risk matrices, Performs calculation of sums of risk in each group but not derivatives but with competing risks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Sides_STRATA_Single_CR <- function(RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, cens_weight, nthreads, debugging, STRATA_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calculate_Sides_STRATA_Single_CR`, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, cens_weight, nthreads, debugging, STRATA_vals, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives
#'
#' \code{Calc_LogLik} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik <- function(nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, debugging, ties_method, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik`, nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, debugging, ties_method, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives, basic model
#'
#' \code{Calc_LogLik_Basic} Basic model, Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Basic <- function(nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, RdR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, debugging, ties_method, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_Basic`, nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, RdR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, debugging, ties_method, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood, basic model
#'
#' \code{Calc_LogLik_Basic_Single} Basic model, Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Basic_Single <- function(nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, Ll, debugging, ties_method, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_Basic_Single`, nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, Ll, debugging, ties_method, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood
#'
#' \code{Calc_LogLik_Single} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_Single <- function(nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, Ll, debugging, ties_method) {
    invisible(.Call(`_Colossus_Calc_LogLik_Single`, nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, Ll, debugging, ties_method))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives with STRATA
#'
#' \code{Calc_LogLik_STRATA} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_STRATA <- function(nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, debugging, ties_method, STRATA_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_STRATA`, nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, RdR, RddR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, debugging, ties_method, STRATA_vals, KeepConstant))
}

#' Utility function to calculate just Cox Log-Likelihood with STRATA
#'
#' \code{Calc_LogLik_STRATA_SINGLE} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time and strata
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_STRATA_SINGLE <- function(nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, Ll, debugging, ties_method, STRATA_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_STRATA_SINGLE`, nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, Ll, debugging, ties_method, STRATA_vals, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives with STRATA, basic model
#'
#' \code{Calc_LogLik_STRATA_BASIC} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time, basic model
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_STRATA_BASIC <- function(nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, RdR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, debugging, ties_method, STRATA_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_STRATA_BASIC`, nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rd, Rdd, RdR, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, Ll, Lld, Lldd, debugging, ties_method, STRATA_vals, KeepConstant))
}

#' Utility function to calculate Cox Log-Likelihood and derivatives with STRATA, basic model, no derivatives
#'
#' \code{Calc_LogLik_STRATA_BASIC_SINGLE} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time, basic model
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_LogLik_STRATA_BASIC_SINGLE <- function(nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, Ll, debugging, ties_method, STRATA_vals, KeepConstant) {
    invisible(.Call(`_Colossus_Calc_LogLik_STRATA_BASIC_SINGLE`, nthreads, RiskFail, RiskGroup, totalnum, ntime, R, Rls1, Lls1, Ll, debugging, ties_method, STRATA_vals, KeepConstant))
}

#' Utility function to calculate poisson log-likelihood and derivatives
#'
#' \code{Poisson_LogLik} Called to update log-likelihoods, Uses list risk matrices and person-years, Sums the log-likelihood contribution from each row
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Poisson_LogLik <- function(nthreads, totalnum, PyrC, R, Rd, Rdd, RdR, RddR, Ll, Lld, Lldd, debugging, KeepConstant) {
    invisible(.Call(`_Colossus_Poisson_LogLik`, nthreads, totalnum, PyrC, R, Rd, Rdd, RdR, RddR, Ll, Lld, Lldd, debugging, KeepConstant))
}

#' Utility function to calculate poisson log-likelihood
#'
#' \code{Poisson_LogLik_Single} Called to update log-likelihoods, Uses list risk matrices and person-years, Sums the log-likelihood contribution from each row
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Poisson_LogLik_Single <- function(nthreads, totalnum, PyrC, R, Ll, debugging) {
    invisible(.Call(`_Colossus_Poisson_LogLik_Single`, nthreads, totalnum, PyrC, R, Ll, debugging))
}

#' Utility function to perform null model equivalent of Calculate_Sides
#'
#' \code{Calculate_Null_Sides} Called to update repeated sum calculations, Uses list of event rows, Performs calculation of counts in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Null_Sides <- function(RiskFail, RiskGroup, ntime, R, Rls1, Lls1, nthreads) {
    invisible(.Call(`_Colossus_Calculate_Null_Sides`, RiskFail, RiskGroup, ntime, R, Rls1, Lls1, nthreads))
}

#' Utility function to perform null model equivalent of Calc_LogLik
#'
#' \code{Calc_Null_LogLik} Called to update log-likelihoods, Uses list of event rows and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_Null_LogLik <- function(nthreads, RiskFail, RiskGroup, ntime, R, Rls1, Lls1, Ll, ties_method) {
    invisible(.Call(`_Colossus_Calc_Null_LogLik`, nthreads, RiskFail, RiskGroup, ntime, R, Rls1, Lls1, Ll, ties_method))
}

#' Utility function to perform null model equivalent of Calculate_Sides with strata
#'
#' \code{Calculate_Null_Sides_STRATA} Called to update repeated sum calculations, Uses list of event rows, Performs calculation of counts in each group
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Calculate_Null_Sides_STRATA <- function(RiskFail, RiskGroup, ntime, R, Rls1, Lls1, STRATA_vals, nthreads) {
    invisible(.Call(`_Colossus_Calculate_Null_Sides_STRATA`, RiskFail, RiskGroup, ntime, R, Rls1, Lls1, STRATA_vals, nthreads))
}

#' Utility function to perform null model equivalent of Calc_LogLik
#'
#' \code{Calc_Null_LogLik_STRATA} Called to update log-likelihoods, Uses list of event rows and repeated sums, Sums the log-likelihood contribution from each event time
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Log-likelihood vectors/matrix
#' @noRd
#'
Calc_Null_LogLik_STRATA <- function(nthreads, RiskFail, RiskGroup, ntime, R, Rls1, Lls1, STRATA_vals, Ll, ties_method) {
    invisible(.Call(`_Colossus_Calc_Null_LogLik_STRATA`, nthreads, RiskFail, RiskGroup, ntime, R, Rls1, Lls1, STRATA_vals, Ll, ties_method))
}

#' checks if the model is viable
#'
#' \code{Check_Risk} Calculates risks and checks for negative values
#'
#' @inheritParams CPP_template
#'
#' @return True for viable point, False for negative error
#' @noRd
#'
Check_Risk <- function(term_n, tform, a_n, x_all, dfc, fir, modelform, verbose, debugging, KeepConstant, term_tot, nthreads, gmix_theta, gmix_term) {
    .Call(`_Colossus_Check_Risk`, term_n, tform, a_n, x_all, dfc, fir, modelform, verbose, debugging, KeepConstant, term_tot, nthreads, gmix_theta, gmix_term)
}

#' Primary Cox PH regression with multiple starting points and optional combinations of null, stratification, competing risks, multiplicative log-linear model, and no derivative calculation.
#'
#' \code{LogLik_Cox_PH_Omnibus} Performs the calls to calculation functions, Structures the Cox PH regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Cox_PH_Omnibus <- function(term_n, tform, a_ns, x_all, dfc, fir, der_iden, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, double_step, change_all, verbose, debugging, KeepConstant, term_tot, ties_method, nthreads, STRATA_vals, cens_weight, strata_bool, basic_bool, null_bool, CR_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_LogLik_Cox_PH_Omnibus`, term_n, tform, a_ns, x_all, dfc, fir, der_iden, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, double_step, change_all, verbose, debugging, KeepConstant, term_tot, ties_method, nthreads, STRATA_vals, cens_weight, strata_bool, basic_bool, null_bool, CR_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res)
}

#' Primary poisson regression with multiple starting points and optional combinations of stratification and no derivative calculation.
#'
#' \code{LogLik_Pois_Omnibus} Performs the calls to calculation functions, Structures the poisson regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Pois_Omnibus <- function(PyrC, term_n, tform, a_ns, x_all, dfc, fir, der_iden, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, double_step, change_all, verbose, debugging, KeepConstant, term_tot, nthreads, dfs, strata_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_LogLik_Pois_Omnibus`, PyrC, term_n, tform, a_ns, x_all, dfc, fir, der_iden, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, double_step, change_all, verbose, debugging, KeepConstant, term_tot, nthreads, dfs, strata_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res)
}

#' Primary Cox PH likelihood bounds calcualtion function.
#'
#' \code{LogLik_Cox_PH_Omnibus_Log_Bound} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Cox_PH_Omnibus_Log_Bound <- function(term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, verbose, debugging, KeepConstant, term_tot, ties_method, nthreads, STRATA_vals, cens_weight, strata_bool, basic_bool, null_bool, CR_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult) {
    .Call(`_Colossus_LogLik_Cox_PH_Omnibus_Log_Bound`, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, verbose, debugging, KeepConstant, term_tot, ties_method, nthreads, STRATA_vals, cens_weight, strata_bool, basic_bool, null_bool, CR_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult)
}

#' Primary Cox PH likelihood bounds calcualtion function.
#'
#' \code{LogLik_Cox_PH_Omnibus_Log_Bound_Search} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Cox_PH_Omnibus_Log_Bound_Search <- function(term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, verbose, debugging, KeepConstant, term_tot, ties_method, nthreads, STRATA_vals, cens_weight, strata_bool, basic_bool, null_bool, CR_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult) {
    .Call(`_Colossus_LogLik_Cox_PH_Omnibus_Log_Bound_Search`, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, verbose, debugging, KeepConstant, term_tot, ties_method, nthreads, STRATA_vals, cens_weight, strata_bool, basic_bool, null_bool, CR_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult)
}

#' Primary Poisson likelihood bounds calculation function.
#'
#' \code{LogLik_Poisson_Omnibus_Log_Bound} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Poisson_Omnibus_Log_Bound <- function(PyrC, dfs, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, verbose, debugging, KeepConstant, term_tot, nthreads, strata_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult) {
    .Call(`_Colossus_LogLik_Poisson_Omnibus_Log_Bound`, PyrC, dfs, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, verbose, debugging, KeepConstant, term_tot, nthreads, strata_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult)
}

#' Primary Poisson likelihood bounds calculation function.
#'
#' \code{LogLik_Poisson_Omnibus_Log_Bound_Search} Performs the calls to calculation functions and log-likeihood profile bounds
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Poisson_Omnibus_Log_Bound_Search <- function(PyrC, dfs, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, verbose, debugging, KeepConstant, term_tot, nthreads, strata_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult) {
    .Call(`_Colossus_LogLik_Poisson_Omnibus_Log_Bound_Search`, PyrC, dfs, term_n, tform, a_n, x_all, dfc, fir, modelform, lr, maxiters, guesses, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, verbose, debugging, KeepConstant, term_tot, nthreads, strata_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res, qchi, para_number, maxstep, mult)
}

#' Primary Cox PH regression with multiple distributed dose columns and optional combinations of null, stratification, competing risks, multiplicative log-linear model, and no derivative calculation.
#'
#' \code{LogLik_Cox_PH_Multidose_Omnibus} Performs the calls to calculation functions, Structures the Cox PH regression, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
LogLik_Cox_PH_Multidose_Omnibus <- function(term_n, tform, a_n, x_all, dose_cols, dose_index, dfc, fir, der_iden, modelform, lr, maxiter, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, double_step, change_all, verbose, debugging, KeepConstant, term_tot, ties_method, nthreads, STRATA_vals, cens_weight, strata_bool, basic_bool, null_bool, CR_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res) {
    .Call(`_Colossus_LogLik_Cox_PH_Multidose_Omnibus`, term_n, tform, a_n, x_all, dose_cols, dose_index, dfc, fir, der_iden, modelform, lr, maxiter, halfmax, epsilon, abs_max, dose_abs_max, deriv_epsilon, df_groups, tu, double_step, change_all, verbose, debugging, KeepConstant, term_tot, ties_method, nthreads, STRATA_vals, cens_weight, strata_bool, basic_bool, null_bool, CR_bool, single_bool, constraint_bool, gmix_theta, gmix_term, Lin_Sys, Lin_Res)
}

#' Utility function to refresh risk and subterm matrices for Cox Omnibus function
#'
#' \code{Cox_Refresh_R_TERM} Called to update matrices
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place
#' @noRd
#'
Cox_Refresh_R_TERM <- function(totalnum, reqrdnum, term_tot, dint, dslp, dose_abs_max, abs_max, df0, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, basic_bool, single_bool) {
    invisible(.Call(`_Colossus_Cox_Refresh_R_TERM`, totalnum, reqrdnum, term_tot, dint, dslp, dose_abs_max, abs_max, df0, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, basic_bool, single_bool))
}

#' Utility function to refresh side matrices for Cox Omnibus
#'
#' \code{Cox_Refresh_R_SIDES} Called to fresh repeated sum calculation matrices
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Cox_Refresh_R_SIDES <- function(reqrdnum, ntime, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, STRATA_vals, strata_bool, single_bool) {
    invisible(.Call(`_Colossus_Cox_Refresh_R_SIDES`, reqrdnum, ntime, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, STRATA_vals, strata_bool, single_bool))
}

#' Utility function to perform calculation of terms and risks for Cox Omnibus
#'
#' \code{Cox_Term_Risk_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Cox_Term_Risk_Calc <- function(modelform, tform, term_n, totalnum, fir, dfc, term_tot, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, beta_0, df0, dint, dslp, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, debugging, KeepConstant, verbose, basic_bool, single_bool, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Cox_Term_Risk_Calc`, modelform, tform, term_n, totalnum, fir, dfc, term_tot, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, beta_0, df0, dint, dslp, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, debugging, KeepConstant, verbose, basic_bool, single_bool, gmix_theta, gmix_term))
}

#' Utility function to perform calculation of Repeated Calculations and Log-Likelihood for Cox Omnibus
#'
#' \code{Cox_Side_LL_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Cox_Side_LL_Calc <- function(reqrdnum, ntime, RiskFail, RiskGroup_Strata, RiskGroup, totalnum, fir, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, STRATA_vals, beta_0, RdR, RddR, Ll, Lld, Lldd, nthreads, debugging, KeepConstant, ties_method, verbose, strata_bool, CR_bool, basic_bool, single_bool, iter_stop) {
    invisible(.Call(`_Colossus_Cox_Side_LL_Calc`, reqrdnum, ntime, RiskFail, RiskGroup_Strata, RiskGroup, totalnum, fir, R, Rd, Rdd, Rls1, Rls2, Rls3, Lls1, Lls2, Lls3, cens_weight, STRATA_vals, beta_0, RdR, RddR, Ll, Lld, Lldd, nthreads, debugging, KeepConstant, ties_method, verbose, strata_bool, CR_bool, basic_bool, single_bool, iter_stop))
}

#' Utility function to perform calculation of terms and risks for Poisson Omnibus
#'
#' \code{Pois_Term_Risk_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Pois_Term_Risk_Calc <- function(modelform, tform, term_n, totalnum, fir, dfc, term_tot, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, beta_0, df0, dint, dslp, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, s_weights, nthreads, debugging, KeepConstant, verbose, strata_bool, single_bool, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Pois_Term_Risk_Calc`, modelform, tform, term_n, totalnum, fir, dfc, term_tot, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, beta_0, df0, dint, dslp, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, s_weights, nthreads, debugging, KeepConstant, verbose, strata_bool, single_bool, gmix_theta, gmix_term))
}

#' Utility function to perform calculation of Log-Likelihood and Deviation for Poisson Omnibus
#'
#' \code{Pois_Dev_LL_Calc} Called to perform repeated term and risk calculations
#' @inheritParams CPP_template
#' @param dev_temp temporary storage for deviation calculation
#' @param dev model deviation
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Pois_Dev_LL_Calc <- function(reqrdnum, totalnum, fir, R, Rd, Rdd, beta_0, RdR, RddR, Ll, Lld, Lldd, PyrC, dev_temp, nthreads, debugging, KeepConstant, verbose, single_bool, iter_stop, dev) {
    invisible(.Call(`_Colossus_Pois_Dev_LL_Calc`, reqrdnum, totalnum, fir, R, Rd, Rdd, beta_0, RdR, RddR, Ll, Lld, Lldd, PyrC, dev_temp, nthreads, debugging, KeepConstant, verbose, single_bool, iter_stop, dev))
}

#' Utility function to check if risk is valid, and if so continue
#'
#' \code{Cox_Pois_Check_Continue} Called to perform repeated risk checks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk, scores, etc storage matrices
#' @noRd
#'
Cox_Pois_Check_Continue <- function(basic_bool, beta_0, beta_best, beta_c, cens_weight, change_all, cox_bool, CR_bool, dbeta, debugging, dev, dev_temp, fir, halfmax, halves, ind0, iter_stop, KeepConstant, Ll, Ll_abs_best, Lld, Lldd, Lls1, Lls2, Lls3, log_bound_bool, Lstar, nthreads, ntime, PyrC, R, Rd, Rdd, RddR, RdR, reqrdnum, RiskFail, RiskGroup, RiskGroup_Strata, Rls1, Rls2, Rls3, single_bool, strata_bool, STRATA_vals, term_n, ties_method, totalnum, TTerm, verbose) {
    invisible(.Call(`_Colossus_Cox_Pois_Check_Continue`, basic_bool, beta_0, beta_best, beta_c, cens_weight, change_all, cox_bool, CR_bool, dbeta, debugging, dev, dev_temp, fir, halfmax, halves, ind0, iter_stop, KeepConstant, Ll, Ll_abs_best, Lld, Lldd, Lls1, Lls2, Lls3, log_bound_bool, Lstar, nthreads, ntime, PyrC, R, Rd, Rdd, RddR, RdR, reqrdnum, RiskFail, RiskGroup, RiskGroup_Strata, Rls1, Rls2, Rls3, single_bool, strata_bool, STRATA_vals, term_n, ties_method, totalnum, TTerm, verbose))
}

#' Utility function to check if risk is valid, and if so continue
#'
#' \code{Cox_Pois_Check_Continue} Called to perform repeated risk checks
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: risk, scores, etc storage matrices
#' @noRd
#'
Cox_Pois_Log_Loop <- function(abs_max, basic_bool, beta_0, beta_a, beta_c, bound_val, cox_bool, dbeta, debugging, df0, dfc, dint, Dose, dose_abs_max, dslp, fir, gmix_term, gmix_theta, half_check, halfmax, KeepConstant, limit_hit, lr, modelform, nonDose, nonDose_LIN, nonDose_LOGLIN, nonDose_PLIN, nthreads, R, Rd, Rdd, RddR, RdR, s_weights, single_bool, strata_bool, T0, Td0, Tdd0, Te, term_n, term_tot, tform, totalnum, TTerm, verbose) {
    invisible(.Call(`_Colossus_Cox_Pois_Log_Loop`, abs_max, basic_bool, beta_0, beta_a, beta_c, bound_val, cox_bool, dbeta, debugging, df0, dfc, dint, Dose, dose_abs_max, dslp, fir, gmix_term, gmix_theta, half_check, halfmax, KeepConstant, limit_hit, lr, modelform, nonDose, nonDose_LIN, nonDose_LOGLIN, nonDose_PLIN, nthreads, R, Rd, Rdd, RddR, RdR, s_weights, single_bool, strata_bool, T0, Td0, Tdd0, Te, term_n, term_tot, tform, totalnum, TTerm, verbose))
}

#' Primary Cox PH baseline hazard function with stratification
#'
#' \code{PLOT_SURV_STRATA} Performs the calls to calculation functions, Uses calculated risks and risk groups to approximate the baseline, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of results: baseline hazard, risk for each row
#' @noRd
#'
PLOT_SURV_STRATA <- function(reqrdnum, R, Rd, a_er, df_groups, tu, STRATA_vals, verbose, debugging, nthreads) {
    .Call(`_Colossus_PLOT_SURV_STRATA`, reqrdnum, R, Rd, a_er, df_groups, tu, STRATA_vals, verbose, debugging, nthreads)
}

#' Primary Cox PH baseline hazard function
#'
#' \code{PLOT_SURV} Performs the calls to calculation functions, Uses calculated risks and risk groups to approximate the baseline, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of results: baseline hazard, risk for each row
#' @noRd
#'
PLOT_SURV <- function(reqrdnum, R, Rd, a_er, df_groups, tu, verbose, debugging, nthreads) {
    .Call(`_Colossus_PLOT_SURV`, reqrdnum, R, Rd, a_er, df_groups, tu, verbose, debugging, nthreads)
}

#' Primary Cox PH schoenfeld residual function
#'
#' \code{Schoenfeld_Calc} Performs the calls to calculation functions, Uses calculated risks and risk groups to calculate the residuals, With verbose option prints out time stamps and intermediate sums of terms and derivatives
#'
#' @inheritParams CPP_template
#'
#' @return List of results: scaled schoenfeld residuals
#' @noRd
#'
Schoenfeld_Calc <- function(ntime, totalnum, beta_0, df0, R, Lldd_inv, RiskFail, RiskGroup, dfc, verbose, debugging, KeepConstant, nthreads) {
    .Call(`_Colossus_Schoenfeld_Calc`, ntime, totalnum, beta_0, df0, R, Lldd_inv, RiskFail, RiskGroup, dfc, verbose, debugging, KeepConstant, nthreads)
}

#' Primary plotting function.
#'
#' \code{Plot_Omnibus} Performs the calls to calculation functions
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
Plot_Omnibus <- function(term_n, tform, a_n, x_all, dfc, fir, der_iden, modelform, abs_max, dose_abs_max, df_groups, tu, verbose, debugging, KeepConstant, term_tot, ties_method, nthreads, STRATA_vals, cens_weight, uniq_v, strata_bool, basic_bool, CR_bool, Surv_bool, Risk_bool, Schoenfeld_bool, Risk_Sub_bool, gmix_theta, gmix_term) {
    .Call(`_Colossus_Plot_Omnibus`, term_n, tform, a_n, x_all, dfc, fir, der_iden, modelform, abs_max, dose_abs_max, df_groups, tu, verbose, debugging, KeepConstant, term_tot, ties_method, nthreads, STRATA_vals, cens_weight, uniq_v, strata_bool, basic_bool, CR_bool, Surv_bool, Risk_bool, Schoenfeld_bool, Risk_Sub_bool, gmix_theta, gmix_term)
}

#' Splits events into background and excess for a poisson regression
#'
#' \code{Assign_Events_Pois} Calculates proportion of events due to background and excess
#'
#' @inheritParams CPP_template
#'
#' @return returns proportion of events due to background and excess for each term
#' @noRd
#'
Assign_Events_Pois <- function(term_n, tform, a_n, x_all, dfc, PyrC, dfs, fir, modelform, verbose, debugging, KeepConstant, term_tot, nthreads, gmix_theta, gmix_term, strata_bool) {
    .Call(`_Colossus_Assign_Events_Pois`, term_n, tform, a_n, x_all, dfc, PyrC, dfs, fir, modelform, verbose, debugging, KeepConstant, term_tot, nthreads, gmix_theta, gmix_term, strata_bool)
}

#' Primary plotting function.
#'
#' \code{Poisson_Residuals} Performs the calls to calculation functions
#'
#' @inheritParams CPP_template
#'
#' @return List of final results: Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
Poisson_Residuals <- function(PyrC, term_n, tform, a_n, x_all, dfc, fir, der_iden, modelform, abs_max, dose_abs_max, verbose, debugging, KeepConstant, term_tot, nthreads, dfs, strata_bool, gmix_theta, gmix_term, Pearson_bool, Deviance_bool) {
    .Call(`_Colossus_Poisson_Residuals`, PyrC, term_n, tform, a_n, x_all, dfc, fir, der_iden, modelform, abs_max, dose_abs_max, verbose, debugging, KeepConstant, term_tot, nthreads, dfs, strata_bool, gmix_theta, gmix_term, Pearson_bool, Deviance_bool)
}

#' Interface between R code and the Cox PH omnibus regression function
#'
#' \code{cox_ph_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
cox_ph_Omnibus_transition <- function(term_n, tform, a_ns, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, STRATA_vals, cens_vec, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_cox_ph_Omnibus_transition`, term_n, tform, a_ns, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, STRATA_vals, cens_vec, model_control, Cons_Mat, Cons_Vec)
}

#' Interface between R code and the poisson omnibus regression function
#'
#' \code{pois_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
pois_Omnibus_transition <- function(dfe, term_n, tform, a_ns, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, df0, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_pois_Omnibus_transition`, dfe, term_n, tform, a_ns, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, df0, model_control, Cons_Mat, Cons_Vec)
}

#' Interface between R code and the event assignment omnibus function
#'
#' \code{Assigned_Event_transition} Called directly from R, Defines the control variables and calls the assigning functions
#' @inheritParams CPP_template
#'
#' @return list of assigned/predicted background/excess events
#' @noRd
#'
Assigned_Event_Poisson_transition <- function(dfe, df0, term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, model_control) {
    .Call(`_Colossus_Assigned_Event_Poisson_transition`, dfe, df0, term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, model_control)
}

#' Interface between R code and the plotting omnibus function
#'
#' \code{Plot_Omnibus_transition} Called directly from R, Defines the control variables and calls the plotting functions
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
Plot_Omnibus_transition <- function(term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, STRATA_vals, cens_vec, model_control) {
    .Call(`_Colossus_Plot_Omnibus_transition`, term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, STRATA_vals, cens_vec, model_control)
}

#' Generates csv file with time-dependent columns
#'
#' \code{Write_Time_Dep} Called directly from R, Defines a new matrix which interpolates time-dependent values on a grid
#' @inheritParams CPP_template
#'
#' @return saves a dataframe to be used with time-dependent covariate analysis
#' @noRd
#'
Write_Time_Dep <- function(df0_Times, df0_dep, df0_const, df0_event, dt, filename, tform_tdep, tu, iscox, nthreads) {
    invisible(.Call(`_Colossus_Write_Time_Dep`, df0_Times, df0_dep, df0_const, df0_event, dt, filename, tform_tdep, tu, iscox, nthreads))
}

#' Generates factored columns in parallel
#'
#' \code{Gen_Fac_Par} Called directly from R, returns a matrix with factored columns
#' @inheritParams CPP_template
#'
#' @return saves a dataframe to be used with time-dependent covariate analysis
#' @noRd
#'
Gen_Fac_Par <- function(df0, vals, cols, nthreads) {
    .Call(`_Colossus_Gen_Fac_Par`, df0, vals, cols, nthreads)
}

#' Interface between R code and the risk check
#'
#' \code{cox_ph_transition_single} Called directly from R, Defines the control variables and calls the function which only calculates the log-likelihood
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
risk_check_transition <- function(term_n, tform, a_n, dfc, x_all, fir, modelform, Control, model_control, KeepConstant, term_tot) {
    .Call(`_Colossus_risk_check_transition`, term_n, tform, a_n, dfc, x_all, fir, modelform, Control, model_control, KeepConstant, term_tot)
}

#' Generates weightings for stratified poisson regression
#'
#' \code{Gen_Strat_Weight} Called from within c++, assigns vector of weights
#' @inheritParams CPP_template
#'
#' @return assigns weight in place and returns nothing
#' @noRd
#'
Gen_Strat_Weight <- function(modelform, dfs, PyrC, s_weights, nthreads, tform, term_n, term_tot) {
    invisible(.Call(`_Colossus_Gen_Strat_Weight`, modelform, dfs, PyrC, s_weights, nthreads, tform, term_n, term_tot))
}

#' Checks the OMP flag
#'
#' \code{OMP_Check} Called directly from R, checks the omp flag and returns if omp is enabled
#'
#' @return boolean: True for OMP allowed
#'
OMP_Check <- function() {
    .Call(`_Colossus_OMP_Check`)
}

#' Interface between R code and the Cox PH omnibus bounds regression function
#'
#' \code{cox_ph_Omnibus_Bounds_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
cox_ph_Omnibus_Bounds_transition <- function(term_n, tform, a_n, dfc, x_all, fir, modelform, Control, df_groups, tu, KeepConstant, term_tot, STRATA_vals, cens_vec, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_cox_ph_Omnibus_Bounds_transition`, term_n, tform, a_n, dfc, x_all, fir, modelform, Control, df_groups, tu, KeepConstant, term_tot, STRATA_vals, cens_vec, model_control, Cons_Mat, Cons_Vec)
}

#' Interface between R code and the poisson omnibus bounds regression function
#'
#' \code{pois_Omnibus_Bounds_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
pois_Omnibus_Bounds_transition <- function(dfe, term_n, tform, a_n, dfc, x_all, fir, modelform, Control, KeepConstant, term_tot, df0, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_pois_Omnibus_Bounds_transition`, dfe, term_n, tform, a_n, dfc, x_all, fir, modelform, Control, KeepConstant, term_tot, df0, model_control, Cons_Mat, Cons_Vec)
}

#' Interface between R code and the poisson residual calculation function
#'
#' \code{pois_Residual_transition} Called directly from R, Defines the control variables and calls the calculation function
#' @inheritParams CPP_template
#'
#' @return Poisson_Residuals output : list of residuals and sum
#' @noRd
#'
pois_Residual_transition <- function(dfe, term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, df0, model_control) {
    .Call(`_Colossus_pois_Residual_transition`, dfe, term_n, tform, a_n, dfc, x_all, fir, der_iden, modelform, Control, KeepConstant, term_tot, df0, model_control)
}

#' Interface between R code and the Cox PH omnibus regression function
#'
#' \code{cox_ph_multidose_Omnibus_transition} Called directly from R, Defines the control variables and calls the regression function
#' @inheritParams CPP_template
#'
#' @return LogLik_Cox_PH output : Log-likelihood of optimum, first derivative of log-likelihood, second derivative matrix, parameter list, standard deviation estimate, AIC, model information
#' @noRd
#'
cox_ph_multidose_Omnibus_transition <- function(term_n, tform, a_n, dose_cols, dose_index, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, STRATA_vals, cens_vec, model_control, Cons_Mat, Cons_Vec) {
    .Call(`_Colossus_cox_ph_multidose_Omnibus_transition`, term_n, tform, a_n, dose_cols, dose_index, dfc, x_all, fir, der_iden, modelform, Control, df_groups, tu, KeepConstant, term_tot, STRATA_vals, cens_vec, model_control, Cons_Mat, Cons_Vec)
}

#' Utility function to keep intercept parameters within the range of possible values
#'
#' \code{Intercept_Bound} Called to update the parameter list in the event that intercepts leave the bounds of possible values
#' @inheritParams CPP_template
#'
#' @return Updates vector in place: parameter vector
#' @noRd
#'
Intercept_Bound <- function(nthreads, totalnum, beta_0, dbeta, dfc, df0, KeepConstant, debugging, tform) {
    invisible(.Call(`_Colossus_Intercept_Bound`, nthreads, totalnum, beta_0, dbeta, dfc, df0, KeepConstant, debugging, tform))
}

#' Utility function to calculate the change to make each iteration, applying linear constraints
#'
#' \code{Calc_Change_Cons} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations with a system of constraints
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
Calc_Change_Cons <- function(Lin_Sys, Lin_Res, beta_0, nthreads, totalnum, der_iden, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, tform, dint, dslp, KeepConstant, debugging) {
    invisible(.Call(`_Colossus_Calc_Change_Cons`, Lin_Sys, Lin_Res, beta_0, nthreads, totalnum, der_iden, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, tform, dint, dslp, KeepConstant, debugging))
}

#' Utility function to calculate the change to make each iteration
#'
#' \code{Calc_Change} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
Calc_Change <- function(double_step, nthreads, totalnum, der_iden, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, change_all, tform, dint, dslp, KeepConstant, debugging) {
    invisible(.Call(`_Colossus_Calc_Change`, double_step, nthreads, totalnum, der_iden, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, change_all, tform, dint, dslp, KeepConstant, debugging))
}

#' Utility function to calculate the change to make each iteration, with basic model
#'
#' \code{Calc_Change_Basic} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
Calc_Change_Basic <- function(double_step, nthreads, totalnum, der_iden, lr, abs_max, Ll, Lld, Lldd, dbeta, change_all, KeepConstant, debugging) {
    invisible(.Call(`_Colossus_Calc_Change_Basic`, double_step, nthreads, totalnum, der_iden, lr, abs_max, Ll, Lld, Lldd, dbeta, change_all, KeepConstant, debugging))
}

#' Utility function to calculate steps for a likelihood based bound
#'
#' \code{Log_Bound} Called to perform likelihood bound steps
#' @inheritParams CPP_template
#' @param Lstar likelihood goal
#' @param L0 current likelihood
#'
#' @return Updates matrices in place: risk storage matrices
#' @noRd
#'
Log_Bound <- function(deriv_max, Lldd_mat, Lld_vec, Lstar, qchi, L0, para_number, nthreads, totalnum, reqrdnum, KeepConstant, term_tot, step, dbeta, beta_0, upper, trouble, verbose, mult) {
    invisible(.Call(`_Colossus_Log_Bound`, deriv_max, Lldd_mat, Lld_vec, Lstar, qchi, L0, para_number, nthreads, totalnum, reqrdnum, KeepConstant, term_tot, step, dbeta, beta_0, upper, trouble, verbose, mult))
}

#' Utility function to calculate the change to make each iteration
#'
#' \code{Calc_Change_trouble} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: parameter change matrix
#' @noRd
#'
Calc_Change_trouble <- function(para_number, nthreads, totalnum, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, tform, dint, dslp, KeepConstant_trouble, debugging) {
    invisible(.Call(`_Colossus_Calc_Change_trouble`, para_number, nthreads, totalnum, dose_abs_max, lr, abs_max, Ll, Lld, Lldd, dbeta, tform, dint, dslp, KeepConstant_trouble, debugging))
}

#' Utility function to calculate the term and subterm values
#'
#' \code{Make_subterms} Called to update term matrices, Uses lists of term numbers and types to apply formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
Make_subterms <- function(totalnum, term_n, tform, dfc, fir, T0, Td0, Tdd0, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, dint, dslp, nthreads, debugging, KeepConstant) {
    invisible(.Call(`_Colossus_Make_subterms`, totalnum, term_n, tform, dfc, fir, T0, Td0, Tdd0, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, dint, dslp, nthreads, debugging, KeepConstant))
}

#' Utility function to calculate the term and subterm values, but not derivatives
#'
#' \code{Make_subterms_Single} Called to update term matrices, Uses lists of term numbers and types to apply formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
Make_subterms_Single <- function(totalnum, term_n, tform, dfc, fir, T0, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, nthreads, debugging, KeepConstant) {
    invisible(.Call(`_Colossus_Make_subterms_Single`, totalnum, term_n, tform, dfc, fir, T0, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, beta_0, df0, nthreads, debugging, KeepConstant))
}

#' Utility function to calculate the term and subterm values with the basic model
#'
#' \code{Make_subterms_Basic} Called to update term matrices, Uses lists of term numbers and types to apply formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: subterm matrices, Term matrices
#' @noRd
Make_subterms_Basic <- function(totalnum, dfc, T0, beta_0, df0, nthreads, debugging) {
    invisible(.Call(`_Colossus_Make_subterms_Basic`, totalnum, dfc, T0, beta_0, df0, nthreads, debugging))
}

#' Utility function to calculate the risk and risk ratios
#'
#' \code{Make_Risks} Called to update risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks <- function(modelform, tform, term_n, totalnum, fir, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, debugging, KeepConstant, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Make_Risks`, modelform, tform, term_n, totalnum, fir, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, debugging, KeepConstant, gmix_theta, gmix_term))
}

#' Utility function to calculate the risk and risk ratios with a weighting applied
#'
#' \code{Make_Risks_Weighted} Called to update weighted risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks_Weighted <- function(modelform, tform, term_n, totalnum, fir, s_weights, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, debugging, KeepConstant, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Make_Risks_Weighted`, modelform, tform, term_n, totalnum, fir, s_weights, T0, Td0, Tdd0, Te, R, Rd, Rdd, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, RdR, RddR, nthreads, debugging, KeepConstant, gmix_theta, gmix_term))
}

#' Utility function to calculate the risk with a weighting applied and no derivatives calculated
#'
#' \code{Make_Risks_Weighted_Single} Called to update weighted risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks_Weighted_Single <- function(modelform, tform, term_n, totalnum, fir, s_weights, T0, Te, R, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, nthreads, debugging, KeepConstant, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Make_Risks_Weighted_Single`, modelform, tform, term_n, totalnum, fir, s_weights, T0, Te, R, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, nthreads, debugging, KeepConstant, gmix_theta, gmix_term))
}

#' Utility function to calculate the risk, but not derivatives
#'
#' \code{Make_Risks_Single} Called to update risk matrices, Splits into cases based on model form
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks_Single <- function(modelform, tform, term_n, totalnum, fir, T0, Te, R, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, nthreads, debugging, KeepConstant, gmix_theta, gmix_term) {
    invisible(.Call(`_Colossus_Make_Risks_Single`, modelform, tform, term_n, totalnum, fir, T0, Te, R, Dose, nonDose, TTerm, nonDose_LIN, nonDose_PLIN, nonDose_LOGLIN, nthreads, debugging, KeepConstant, gmix_theta, gmix_term))
}

#' Utility function to calculate the risk and risk ratios for the basic model
#'
#' \code{Make_Risks_Basic} Called to update risk matrices, Splits into cases based on model form, Uses lists of term numbers and types to apply different derivative formulas
#' @inheritParams CPP_template
#'
#' @return Updates matrices in place: Risk, Risk ratios
#' @noRd
Make_Risks_Basic <- function(totalnum, T0, R, Rd, Rdd, RdR, nthreads, debugging, df0, dfc, KeepConstant) {
    invisible(.Call(`_Colossus_Make_Risks_Basic`, totalnum, T0, R, Rd, Rdd, RdR, nthreads, debugging, df0, dfc, KeepConstant))
}

