% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Poisson_Regression.R
\name{RunPoissonEventAssignment_bound}
\alias{RunPoissonEventAssignment_bound}
\title{Predicts how many events are due to baseline vs excess at the confidence bounds of a single parameter}
\usage{
RunPoissonEventAssignment_bound(
  df,
  pyr0 = "pyr",
  event0 = "event",
  alternative_model = list(),
  keep_constant = c(0),
  modelform = "M",
  fir = 0,
  der_iden = 0,
  check_num = 1,
  z = 2,
  control = list(),
  strat_col = "null",
  model_control = list()
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{pyr0}{column used for person-years per row}

\item{event0}{column used for event status}

\item{alternative_model}{the new model of interest in list form, output from a poisson regression}

\item{keep_constant}{binary values to denote which parameters to change}

\item{modelform}{string specifying the model type: M, ME, A, PA, PAE, GMIX, GMIX-R, GMIX-E}

\item{fir}{term number for the initial term, used for models of the form T0*f(Ti) in which the order matters}

\item{der_iden}{number for the subterm to test derivative at, only used for testing runs with a single varying parameter, should be smaller than total number of parameters. indexed starting at 0}

\item{check_num}{the parameter number to check at the bounds of, indexed from 1 using the order returned by Colossus}

\item{z}{Z score to use for confidence interval}

\item{control}{list of parameters controlling the convergence, see Def_Control() for options or vignette("Control_Options")}

\item{strat_col}{column to stratify by if needed}

\item{model_control}{controls which alternative model options are used, see Def_model_control() for options and vignette("Control_Options") for further details}
}
\value{
returns a list of the final results
}
\description{
\code{RunPoissonEventAssignment_bound} uses user provided data, the results of a poisson regression, and options to calculate background and excess events
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette
df <- data.table::data.table(
  "UserID" = c(112, 114, 213, 214, 115, 116, 117),
  "Starting_Age" = c(18, 20, 18, 19, 21, 20, 18),
  "Ending_Age" = c(30, 45, 57, 47, 36, 60, 55),
  "Cancer_Status" = c(0, 0, 1, 0, 1, 0, 0),
  "a" = c(0, 1, 1, 0, 1, 0, 1),
  "b" = c(1, 1.1, 2.1, 2, 0.1, 1, 0.2),
  "c" = c(10, 11, 10, 11, 12, 9, 11),
  "d" = c(0, 0, 0, 1, 1, 1, 1),
  "e" = c(0, 0, 1, 0, 0, 0, 1)
)
# For the interval case
pyr <- "Ending_Age"
event <- "Cancer_Status"
names <- c("a", "b", "c", "d")
a_n <- c(1.1, -0.1, 0.2, 0.5) # used to test at a specific point
term_n <- c(0, 1, 1, 2)
tform <- c("loglin", "lin", "lin", "plin")
modelform <- "M"
fir <- 0
keep_constant <- c(0, 0, 0, 0)
der_iden <- 0
control <- list(
  "ncores" = 2, "lr" = 0.75, "maxiter" = 5, "halfmax" = 5, "epsilon" = 1e-3,
  "deriv_epsilon" = 1e-3, "abs_max" = 1.0, "change_all" = TRUE,
  "dose_abs_max" = 100.0, "verbose" = FALSE, "ties" = "breslow",
  "double_step" = 1
)
guesses_control <- list(
  "maxiter" = 10, "guesses" = 10, "lin_min" = 0.001,
  "lin_max" = 1, "loglin_min" = -1, "loglin_max" = 1, "lin_method" = "uniform",
  "loglin_method" = "uniform", strata = FALSE
)
strat_col <- "e"
e0 <- RunPoissonRegression_Omnibus(
  df, pyr, event, names, term_n, tform,
  keep_constant,
  a_n, modelform, fir, der_iden,
  control, strat_col
)
e <- RunPoissonEventAssignment_bound(
  df, pyr, event, e0, keep_constant,
  modelform, fir, der_iden, 4, 2, control
)
}
\seealso{
Other Poisson Wrapper Functions: 
\code{\link{RunPoissonEventAssignment}()},
\code{\link{RunPoissonRegression}()},
\code{\link{RunPoissonRegression_Guesses_CPP}()},
\code{\link{RunPoissonRegression_Joint_Omnibus}()},
\code{\link{RunPoissonRegression_Omnibus}()},
\code{\link{RunPoissonRegression_Residual}()},
\code{\link{RunPoissonRegression_STRATA}()},
\code{\link{RunPoissonRegression_Single}()},
\code{\link{RunPoissonRegression_Tier_Guesses}()}
}
\concept{Poisson Wrapper Functions}
