% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cox_Regression.R
\name{CoxCurveSolver}
\alias{CoxCurveSolver}
\title{Calculates the likelihood curve for a cox model directly}
\usage{
CoxCurveSolver(
  df,
  time1 = "start",
  time2 = "end",
  event0 = "event",
  names = c("CONST"),
  term_n = c(0),
  tform = "loglin",
  keep_constant = c(0),
  a_n = c(0),
  modelform = "M",
  fir = 0,
  der_iden = 0,
  control = list(),
  strat_col = "null",
  cens_weight = "null",
  model_control = list(),
  cons_mat = as.matrix(c(0)),
  cons_vec = c(0)
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{time1}{column used for time period starts}

\item{time2}{column used for time period end}

\item{event0}{column used for event status}

\item{names}{columns for elements of the model, used to identify data columns}

\item{term_n}{term numbers for each element of the model}

\item{tform}{list of string function identifiers, used for linear/step}

\item{keep_constant}{binary values to denote which parameters to change}

\item{a_n}{list of initial parameter values, used to determine number of parameters. May be either a list of vectors or a single vector.}

\item{modelform}{string specifying the model type: M, ME, A, PA, PAE, GMIX, GMIX-R, GMIX-E}

\item{fir}{term number for the initial term, used for models of the form T0*f(Ti) in which the order matters}

\item{der_iden}{number for the subterm to test derivative at, only used for testing runs with a single varying parameter, should be smaller than total number of parameters. indexed starting at 0}

\item{control}{list of parameters controlling the convergence, see Def_Control() for options or vignette("Control_Options")}

\item{strat_col}{column to stratify by if needed}

\item{cens_weight}{column containing the row weights}

\item{model_control}{controls which alternative model options are used, see Def_model_control() for options and vignette("Control_Options") for further details}

\item{cons_mat}{Matrix containing coefficients for system of linear constraints, formatted as matrix}

\item{cons_vec}{Vector containing constants for system of linear constraints, formatted as vector}
}
\value{
returns a list of the final results
}
\description{
\code{CoxCurveSolver} solves the confidence interval for a cox model, starting at the optimum point and
iteratively optimizing end-points of intervals. Intervals updated using the bisection method.
}
\seealso{
Other Cox Wrapper Functions: 
\code{\link{RunCoxNull}()},
\code{\link{RunCoxRegression}()},
\code{\link{RunCoxRegression_Basic}()},
\code{\link{RunCoxRegression_CR}()},
\code{\link{RunCoxRegression_Guesses_CPP}()},
\code{\link{RunCoxRegression_Omnibus}()},
\code{\link{RunCoxRegression_Omnibus_Multidose}()},
\code{\link{RunCoxRegression_Single}()},
\code{\link{RunCoxRegression_Strata}()},
\code{\link{RunCoxRegression_Tier_Guesses}()}
}
\concept{Cox Wrapper Functions}
