% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cox_Regression.R
\name{RunCoxPlots}
\alias{RunCoxPlots}
\title{Performs Cox Proportional Hazard model plots}
\usage{
RunCoxPlots(
  df,
  time1 = "start",
  time2 = "end",
  event0 = "event",
  names = c("CONST"),
  term_n = c(0),
  tform = "loglin",
  keep_constant = c(0),
  a_n = c(0),
  modelform = "M",
  fir = 0,
  control = list(),
  plot_options = list(),
  model_control = list()
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{time1}{column used for time period starts}

\item{time2}{column used for time period end}

\item{event0}{column used for event status}

\item{names}{columns for elements of the model, used to identify data columns}

\item{term_n}{term numbers for each element of the model}

\item{tform}{list of string function identifiers, used for linear/step}

\item{keep_constant}{binary values to denote which parameters to change}

\item{a_n}{list of initial parameter values, used to determine number of parameters. May be either a list of vectors or a single vector.}

\item{modelform}{string specifying the model type: M, ME, A, PA, PAE, GMIX, GMIX-R, GMIX-E}

\item{fir}{term number for the initial term, used for models of the form T0*f(Ti) in which the order matters}

\item{control}{list of parameters controlling the convergence, see Def_Control() for options or vignette("Control_Options")}

\item{plot_options}{list of parameters controlling the plot options, see RunCoxPlots() for different options}

\item{model_control}{controls which alternative model options are used, see Def_model_control() for options and vignette("Control_Options") for further details}
}
\value{
saves the plots in the current directory and returns the data used for plots
}
\description{
\code{RunCoxPlots} uses user provided data, time/event columns,
vectors specifying the model, and options to choose and save plots
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette
df <- data.table::data.table(
  "UserID" = c(112, 114, 213, 214, 115, 116, 117),
  "Starting_Age" = c(18, 20, 18, 19, 21, 20, 18),
  "Ending_Age" = c(30, 45, 57, 47, 36, 60, 55),
  "Cancer_Status" = c(0, 0, 1, 0, 1, 0, 0),
  "a" = c(0, 1, 1, 0, 1, 0, 1),
  "b" = c(1, 1.1, 2.1, 2, 0.1, 1, 0.2),
  "c" = c(10, 11, 10, 11, 12, 9, 11),
  "d" = c(0, 0, 0, 1, 1, 1, 1)
)
# For the interval case
time1 <- "Starting_Age"
time2 <- "Ending_Age"
event <- "Cancer_Status"
names <- c("a", "b", "c", "d")
term_n <- c(0, 1, 1, 2)
tform <- c("loglin", "lin", "lin", "plin")
modelform <- "M"
fir <- 0
a_n <- c(-0.1, 0.5, 1.1, -0.3)
keep_constant <- c(0, 0, 0, 0)
der_iden <- 0
control <- list(
  "ncores" = 2, "lr" = 0.75, "maxiter" = -1, "halfmax" = 5,
  "epsilon" = 1e-3, "deriv_epsilon" = 1e-3,
  "abs_max" = 1.0, "change_all" = TRUE, "dose_abs_max" = 100.0,
  "verbose" = FALSE, "ties" = "breslow", "double_step" = 1
)
# setting maxiter below 0 forces the function to calculate the score
# and return
plot_options <- list(
  "type" = c("surv", paste(tempfile(),
    "run",
    sep = ""
  )), "studyid" = "UserID",
  "verbose" = FALSE
)
RunCoxPlots(
  df, time1, time2, event, names, term_n, tform, keep_constant,
  a_n, modelform, fir, control, plot_options
)

}
\seealso{
Other Plotting Wrapper Functions: 
\code{\link{Cox_Relative_Risk}()}
}
\concept{Plotting Wrapper Functions}
