% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{plot.FuncompCGL}
\alias{plot.FuncompCGL}
\title{Plot solution paths from a \code{"FuncompCGL"} object.}
\usage{
\method{plot}{FuncompCGL}(x, ylab = c("L2", "L1"), xlab = c("log", "-log", "lambda"), ...)
}
\arguments{
\item{x}{fitted \code{"FuncompCGL"} object.}

\item{ylab}{what is the on Y-axis,
\code{"L2"} (default) plots against the L2-norm of each group of coefficients,
\code{"L1"} against L1-norm.}

\item{xlab}{what is on the X-axis,
\code{"log"} plots against \code{log(lambda)} (default),
\code{"-log"} against \code{-log(lambda)}, and \code{"lambda"} against \code{lambda}.}

\item{\dots}{other graphical parameters.}
}
\value{
No return value. Side effect is a base R plot.
}
\description{
Produce a coefficient profile plot of the coefficient paths for a fitted
\code{"FuncompCGL"} object.
}
\details{
A solution path plot is produced.
}
\examples{
df_beta = 5
p = 30
beta_C_true = matrix(0, nrow = p, ncol = df_beta)
beta_C_true[1, ] <- c(-0.5, -0.5, -0.5 , -1, -1)
beta_C_true[2, ] <- c(0.8, 0.8,  0.7,  0.6,  0.6)
beta_C_true[3, ] <- c(-0.8, -0.8 , 0.4 , 1 , 1)
beta_C_true[4, ] <- c(0.5, 0.5, -0.6  ,-0.6, -0.6)
Data <- Fcomp_Model(n = 50, p = p, m = 0, intercept = TRUE,
                    SNR = 4, sigma = 3, rho_X = 0, rho_T = 0.6, df_beta = df_beta,
                    n_T = 20, obs_spar = 1, theta.add = FALSE,
                    beta_C = as.vector(t(beta_C_true)))
m1 <- FuncompCGL(y = Data$data$y, X = Data$data$Comp, Zc = Data$data$Zc,
                 intercept = Data$data$intercept, k = df_beta, tol = 1e-10)
plot(m1)
plot(m1, ylab = "L1", xlab = "-log")

}
\references{
Sun, Z., Xu, W., Cong, X., Li G. and Chen K. (2020) \emph{Log-contrast regression with
functional compositional predictors: linking preterm infant's gut microbiome trajectories
to neurobehavioral outcome}, \href{https://arxiv.org/abs/1808.02403}{https://arxiv.org/abs/1808.02403}
\emph{Annals of Applied Statistics}
}
\seealso{
\code{\link{FuncompCGL}}, and \code{\link[=predict.FuncompCGL]{predict}},
\code{\link[=coef.FuncompCGL]{coef}} and \code{\link[=print.FuncompCGL]{print}}
methods for \code{"FuncompCGL"} object.
}
\author{
Zhe Sun and Kun Chen
}
