% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn.R
\name{geom_venn_label_region}
\alias{geom_venn_label_region}
\title{Label for a region of Venn diagram}
\usage{
geom_venn_label_region(
  data,
  mapping = aes_(),
  sets = NULL,
  outwards_adjust = 1.3,
  fill = alpha("white", 0.85),
  size = 5,
  label.size = 0,
  ...
)
}
\arguments{
\item{data}{a dataframe including binary columns representing membership in sets}

\item{mapping}{the aesthetics mapping}

\item{sets}{vector with names of columns representing membership in sets}

\item{outwards_adjust}{the multiplier defining the distance from the centre}

\item{fill}{the fill of the label}

\item{size}{the text size}

\item{label.size}{the size of the label outline}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:geom_text]{ggplot2::geom_label}}
  \describe{
    \item{\code{stat}}{The statistical transformation to use on the data for this
layer, as a string.}
    \item{\code{position}}{Position adjustment, either as a string, or the result of
a call to a position adjustment function. Cannot be jointy specified with
\code{nudge_x} or \code{nudge_y}.}
    \item{\code{parse}}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}
    \item{\code{nudge_x}}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}
    \item{\code{nudge_y}}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}
    \item{\code{label.padding}}{Amount of padding around label. Defaults to 0.25 lines.}
    \item{\code{label.r}}{Radius of rounded corners. Defaults to 0.15 lines.}
    \item{\code{na.rm}}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}
    \item{\code{show.legend}}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}
    \item{\code{inherit.aes}}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
  }}
}
\description{
Label for a region of Venn diagram
}
