% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlatrix.R
\name{ctrx}
\alias{ctrx}
\alias{correlatrix}
\title{Correlatrix}
\usage{
ctrx(data, x = NULL, y = NULL, triangle = "both", round = 2,
  method = "pearson", n.matrix = F, abbreviate = 100,
  stars = c(0.05, 0.01, 0.001), partial = c(), describe = F,
  leading.zero = T, ...)
}
\arguments{
\item{data}{a data.frame or imputationList.}

\item{x}{a vector of variable names to correlate (optional).}

\item{y}{a vector of column names for the creation of asymmetric correlation matrices.}

\item{triangle}{a string containing one of "lower" "upper" or "both". Indicates if correlations are to be displayed above or below the diagonal. "Both" is selected by default.}

\item{round}{a numeral indicating number of decimals.}

\item{method}{a string containing one of "pearson","spearman" or "kendall".}

\item{n.matrix}{logical. If TRUE, matrix of n returned.}

\item{abbreviate}{a number indicating the maximum length of variable names.}

\item{stars}{a numeric vector. For each numeral, a star will be assigned which indicates that the p-value for a given correlation was at, or smaller than, that level. The default is 0.05, 0.01 and 0.001.}

\item{partial}{a vector of colnames. If supplied the function will output a matrix of partial correlations. All effects will be controlled for by the variables in this vector.}

\item{describe}{a list of functions with names or a logical. If functions are supplied to describe, a new column will be appended to the final data.frame for each argument in the list. If TRUE is supplied, means and standard deviation is appended with na.rm = T.}

\item{leading.zero}{a logical. If FALSE, leading zeros are removed.}

\item{...}{the argument 'var.names' from previous versions has been deprecated, please use x instead.}
}
\value{
A data.frame containing a correlation matrix.
}
\description{
Takes in a data.frame or imputationList, a vector of variable names and produces a correlation matrix with customizable significance stars.
}
\examples{
correlatrix(mtcars[,1:5])
library(magrittr)
mtcars \%>\%
ctrx(x = c("mpg","cyl","disp")
,y = c("wt","drat"),
round = 2,
stars = c(0.05),
describe = list("mean" = function(x) mean(x,na.rm=TRUE)))
}
