% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExclusiveConnectedness.R
\name{ExclusiveConnectedness}
\alias{ExclusiveConnectedness}
\title{Exclusive Connectedness Measures}
\usage{
ExclusiveConnectedness(dca, group = c(1, 2), start = NULL, end = NULL)
}
\arguments{
\item{dca}{Dynamic connectedness object}

\item{group}{Vector of group indices}

\item{start}{Start index}

\item{end}{End index}
}
\value{
Get connectedness measures
}
\description{
This function results in exclusive connectedness measures
}
\examples{
\donttest{
#Replication of Chatziantoniou, et al. (2022)
data("cegg2022")
dca = ConnectednessApproach(cegg2022,
                            nlag=1,
                            nfore=20,
                            model="TVP-VAR",
                            connectedness="Time",
                            corrected=TRUE,
                            VAR_config=list(TVPVAR=list(kappa1=0.99, 
                            kappa2=0.99, prior="BayesPrior")))
exc = ExclusiveConnectedness(dca, group=c(1,2,3))
}
}
\author{
David Gabauer
}
