% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FASTDECOR.R
\name{FASTDECOR}
\alias{FASTDECOR}
\title{FAST algorithm calling DECOR}
\usage{
FASTDECOR(
  X,
  Wk = NULL,
  maxiter = 10,
  NP = 15,
  L = 100,
  FF = 0.4,
  CR = 0.9,
  FULL = FALSE,
  PS = TRUE
)
}
\arguments{
\item{X}{A N by M data matrix, in which there are N judges and M objects to be judged. Each row is a ranking of the objects which are represented by the columns. Alternatively X can contain the rankings observed only once. In this case the argument Wk must be used}

\item{Wk}{Optional: the frequency of each ranking in the data}

\item{maxiter}{maximum number of iterations. Default 10}

\item{NP}{The number of population individuals}

\item{L}{Generations limit: maximum number of consecutive generations without improvement}

\item{FF}{The scaling rate for mutation. Must be in [0,1]}

\item{CR}{The crossover range. Must be in [0,1]}

\item{FULL}{Default FULL=FALSE. If FULL=TRUE, the searching is limited to the space of full rankings. In this case, the data matrix must contain full rankings.}

\item{PS}{Default PS=TRUE. If PS=TRUE the number of a multiple of 5 iterations is diplayed}
}
\value{
a "list" containing the following components:
\tabular{lll}{
Consensus \tab  \tab the Consensus Ranking\cr
Tau \tab       \tab averaged TauX rank correlation coefficient\cr
Eltime\tab   \tab Elapsed time in seconds}
}
\description{
FAST algorithm repeats DECOR a prespecified number of time. 
It returns the best solutions among the iterations
}
\details{
This function is deprecated and it will be removed in the 
next release of the package. Use function 'consrank' instead.
}
\examples{
#data(EMD)
#CR=FASTDECOR(EMD[,1:15],EMD[,16])

}
\references{
D'Ambrosio, A., Mazzeo, G., Iorio, C., and Siciliano, R. (2017). A differential evolution algorithm for finding the median ranking under the Kemeny axiomatic approach. Computers and Operations Research, vol. 82, pp. 126-138.
}
\seealso{
\code{\link{consrank}}
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it} and Giulio Mazzeo \email{giuliomazzeo@gmail.com}
}
\keyword{Differential}
\keyword{Median}
\keyword{evolution}
\keyword{ranking}
