% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_tweets.r
\name{reshape_tweets}
\alias{reshape_tweets}
\title{reshape_tweets}
\usage{
reshape_tweets(
  tweets,
  intent = c("retweets", "hashtags", "urls", "urls_domains")
)
}
\arguments{
\item{tweets}{a named list of Twitter data
(output of \link{preprocess_tweets})}

\item{intent}{the desired intent for analysis.}
}
\value{
a reshaped data.table
}
\description{
Reshape twitter data for coordination detection.
}
\details{
This function takes the pre-processed Twitter data
(output of \link{preprocess_tweets}) and reshapes it
for coordination detection (\link{detect_coordinated_groups}).
You can choose the intent for reshaping the data. Use
\code{"retweets"} to detect coordinated retweeting behaviour;
\code{"hashtags"} for coordinated usage of hashtags;
\code{"urls"} to detect coordinated link sharing behaviour;
\code{"urls_domain"} to detect coordinated link sharing behaviour
at the domain level.
The output of this function is a reshaped \code{data.table} that
can be passed to \link{detect_coordinated_groups}.
}
