% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentroidWeberSetConcept.R
\name{drawCentroidWeberSet}
\alias{drawCentroidWeberSet}
\title{draw centroid of Weber set for 3 or 4 players}
\usage{
drawCentroidWeberSet(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "centroid of Weber set")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawCentroidWeberset draws the centroid of the Weber set for 3 or 4 players.
}
\examples{
library(CoopGame)
v <-c(1,2,3,60,60,60,142)
drawCentroidWeberSet(v,colour="blue")
}
\references{
Weber R.J. (1988) "Probabilistic values for games". In: Roth A.E. (Ed.), The Shapley Value. Essays in in honor of Lloyd S. Shapley, Cambridge University Press, pp. 101--119

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 327--329
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
