% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GameProperty1Convexity.R
\name{is1ConvexGame}
\alias{is1ConvexGame}
\title{Check if game is 1-Convex}
\usage{
is1ConvexGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is 1-convex, else \code{FALSE}
}
\description{
is1ConvexGame checks if a TU game is 1-convex.
A TU game is 1-convex if and only if the following condition holds true:
Let \code{S} be a nonempty coalition. Whenever all
players outside \code{S} receive their payoffs according to the
utopia payoff of the game, then the remaining part of the total savings 
is at least \code{v(S)}.
}
\examples{
library(CoopGame)
is1ConvexGame(c(0,0,0,9,9,12,18))

\donttest{
#1-convex game (taken from book by T. Driessen, p. 75)
library(CoopGame)
v=c(0,0,0,9,9,15,18)
is1ConvexGame(v)

#Example of a game which is not 1-convex 
library(CoopGame)
v=c(1:7)
is1ConvexGame(v)
}

}
\references{
Driessen T. (1998) \emph{Cooperative Games, Solutions and Applications}, Springer, p. 73
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
