% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertyBalancedness.R
\name{isBalancedGame}
\alias{isBalancedGame}
\title{Check if game is balanced}
\usage{
isBalancedGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is balanced, else \code{FALSE}
}
\description{
Checks if a game is balanced. A game is 
balanced if the core is a nonempty set.
}
\examples{
library(CoopGame)
v=c(0,0,0,40,50,20,100)
isBalancedGame(v)

\donttest{
#Example of an unbalanced game with 3 players
library(CoopGame)
v=c(1,1,1,2,3,4,3)
isBalancedGame(v)

#Example of an unbalanced game with 4 players
library(CoopGame)
v=c(0,0,0,0,1,0,0,0,0,3,3,3,3,3,4)
isBalancedGame(v)

#Example of a balanced game with 4 players
library(CoopGame)
v= c(0,0,0,0,1,0,0,0,0,2,2,2,2,2,4)
isBalancedGame(v)
}

}
\references{
Bondareva O.N. (1963) "Some applications of linear programming methods to the theory of cooperative games". Problemy kibernetiki 10, pp. 119--139

Shapley L.S. (1967) "On Balanced Sets and Cores". Naval Research Logistics Quarterly 14, pp. 453--460

Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, pp. 27--32

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 691--702

Slikker M. and van den Nouweland A. (2001) \emph{Social and Economic Networks in Cooperative Game Theory}, Springer, pp. 6--7

Osborne M.J. and Rubinstein A. (1994) \emph{A Course in Game Theory}, MIT Press, pp. 262--263
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
