% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertykConvexity.R
\name{iskConvexGame}
\alias{iskConvexGame}
\title{Check if game is k-Convex}
\usage{
iskConvexGame(v, k)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{k}{An integer specifying k}
}
\value{
\code{TRUE} if the game is k-convex, else \code{FALSE}
}
\description{
iskConvexGame checks if a TU game is k-convex.
A TU game is k-convex if and only if its k-cover exists 
and is convex. See section 7.1 of the book by Driessen 
for more details
}
\examples{
library(CoopGame)
iskConvexGame(v=c(0,0,0,9,9,12,18), k=1)

\donttest{
# Two examples motivated by the book by T. Driessen, p. 175:
#
# The following game is 2-convex 
library(CoopGame)
alpha = 0.4
v=c(0,0,0,alpha,alpha,0,1)
iskConvexGame(v,2)

# The following game is not 2-convex 
library(CoopGame)
alpha = 0.7
v=c(0,0,0,alpha,alpha,0,1)
iskConvexGame(v,2)
}

}
\references{
Driessen T. (1998) \emph{Cooperative Games, Solutions and Applications}, Springer, p. 171--178
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
