% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShapleyConcept.R
\name{shapleyShubikIndex}
\alias{shapleyShubikIndex}
\title{Compute Shapley-Shubik index}
\usage{
shapleyShubikIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Shapley-Shubik index for given simple game
}
\description{
Calculates the Shapley-Shubik index for a specified simple game with n players. 
Note that no separate drawing routine for the Shapley-Shubik index is provide 
as users can always resort to \link{drawShapleyValue}
}
\examples{
library(CoopGame)
shapleyShubikIndex(v=c(0,0,0,0,1,0,1))

\donttest{
#Example from Stach (2011):
library(CoopGame)
v=weightedVotingGameVector(n=4,q=50,w=c(10,10,20,30))
shapleyShubikIndex(v)
#[1] 0.08333333 0.08333333 0.25000000 0.58333333
}

}
\references{
Shapley L.S. and Shubik M. (1954) "A method for evaluating the distribution of power in a committee system". American political science review 48(3), pp. 787--792

Shapley L.S. (1953) "A value for n-person games". In: Kuhn, H., Tucker, A.W. (Eds.), Contributions to the Theory of Games II, Princeton University Press, pp. 307--317

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 156--159

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 748--781

Stach I. (2011) "Shapley-Shubik index", Encyclopedia of Power, SAGE Publications, pp. 603--606
}
\author{
Alexandra Tiukkel

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
