% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInvalidCoalitionS}
\alias{stopOnInvalidCoalitionS}
\title{Parameter Function stopOnInvalidCoalitionS}
\usage{
stopOnInvalidCoalitionS(paramCheckResult, S, N = NULL, n = NULL,
  v = NULL)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{S}{numeric vector with coalition of players}

\item{N}{represents the grand coalition.}

\item{n}{represents the number of players}

\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\description{
stopOnInvalidCoalitionS checks if coalition S as subset of grand coalition N 
             is specified correctly and causes calculation to stop otherwise.
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1020 \tab Coalition vector S is invalid as 'NULL' \cr
1021 \tab Coalition vector S is invalid as not numeric \cr
1022 \tab Coalition vector S no subset of grand coalition N \cr
1023 \tab The number of players in S cannot be greater than the number of players in N \cr
1024 \tab Specified coalition is inconsistent with game vector}
}

\examples{
library(CoopGame)
paramCheckResult=getEmptyParamCheckResult()
validCoalition = c(1,2,3)
stopOnInvalidCoalitionS(paramCheckResult, S=validCoalition, N=c(1,2,3,4,5))

}
\seealso{
Other ParameterChecks_CoopGame: \code{\link{getEmptyParamCheckResult}},
  \code{\link{stopOnInconsistentEstateAndClaimsVector}},
  \code{\link{stopOnInvalidAllocation}},
  \code{\link{stopOnInvalidBoolean}},
  \code{\link{stopOnInvalidClaimsVector}},
  \code{\link{stopOnInvalidDictator}},
  \code{\link{stopOnInvalidEstate}},
  \code{\link{stopOnInvalidGameVector}},
  \code{\link{stopOnInvalidGrandCoalitionN}},
  \code{\link{stopOnInvalidIndex}},
  \code{\link{stopOnInvalidLeftRightGloveGame}},
  \code{\link{stopOnInvalidNChooseB}},
  \code{\link{stopOnInvalidNumberOfPlayers}},
  \code{\link{stopOnInvalidNumber}},
  \code{\link{stopOnInvalidQuota}},
  \code{\link{stopOnInvalidVetoPlayer}},
  \code{\link{stopOnInvalidWeightVector}},
  \code{\link{stopOnParamCheckError}}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
\concept{ParameterChecks_CoopGame}
