% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInvalidLeftRightGloveGame}
\alias{stopOnInvalidLeftRightGloveGame}
\title{Parameter Function stopOnInvalidLeftRightGloveGame}
\usage{
stopOnInvalidLeftRightGloveGame(paramCheckResult, L, R, N)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{L}{numeric vector of players owning one left-hand glove each}

\item{R}{numeric vector of players owning one right-hand glove each}

\item{N}{represents the grand coalition.}
}
\description{
stopOnInvalidLeftRightGloveGame checks if L (left gloves) 
 and R (right gloves) are specified as parameter correctly (also regarding grand coalition).
 Validation result gets stored to object paramCheckResult 
 in case an error occured and causes calculation to stop.
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1140 \tab Not all players in L and R included. \cr
1141 \tab L must have size > 0. \cr
1142 \tab R must have size > 0. \cr
1143 \tab L and R have to be disjoint sets. }
}

\examples{
library(CoopGame)
paramCheckResult=getEmptyParamCheckResult()
validL=c(1,3)
validR=c(2)
stopOnInvalidLeftRightGloveGame(paramCheckResult, L=validL,R=validR,N=c(1,2,3))

}
\seealso{
Other ParameterChecks_CoopGame: \code{\link{getEmptyParamCheckResult}},
  \code{\link{stopOnInconsistentEstateAndClaimsVector}},
  \code{\link{stopOnInvalidAllocation}},
  \code{\link{stopOnInvalidBoolean}},
  \code{\link{stopOnInvalidClaimsVector}},
  \code{\link{stopOnInvalidCoalitionS}},
  \code{\link{stopOnInvalidDictator}},
  \code{\link{stopOnInvalidEstate}},
  \code{\link{stopOnInvalidGameVector}},
  \code{\link{stopOnInvalidGrandCoalitionN}},
  \code{\link{stopOnInvalidIndex}},
  \code{\link{stopOnInvalidNChooseB}},
  \code{\link{stopOnInvalidNumberOfPlayers}},
  \code{\link{stopOnInvalidNumber}},
  \code{\link{stopOnInvalidQuota}},
  \code{\link{stopOnInvalidVetoPlayer}},
  \code{\link{stopOnInvalidWeightVector}},
  \code{\link{stopOnParamCheckError}}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
\concept{ParameterChecks_CoopGame}
