% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnanimityGame.R
\name{unanimityGame}
\alias{unanimityGame}
\title{Construct a unanimity game}
\usage{
unanimityGame(n, T)
}
\arguments{
\item{n}{represents the number of players}

\item{T}{represents coalition which is subset of grand coalition and neccessary for generating value}
}
\value{
A list with three elements 
representing the unanimity game (n, T, Game vector v)
}
\description{
\strong{Create a list containing 
all information about a specified unanimity game:}\cr
The player in coalition \code{T} are the productive players.
If all players from \code{T} are included, the coalition 
generates value \code{1}, otherwise \code{0}. \cr
Note that unanimity games are always simple games.
}
\section{Related Functions}{
 
\link{unanimityGameValue}, \link{unanimityGameVector}
}

\examples{
library(CoopGame)
unanimityGame(n=3,T=c(1,2))

\donttest{
library(CoopGame)
unanimityGame(n=4,T=c(1,2))
#Output
#$n
#[1] 4
#
#$T
#[1] 1 2

#$v
#[1] 0 0 0 0 1 0 0 0 0 0 1 1 0 0 1
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 152

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 764
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
