% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_VRT_from_dir}
\alias{create_VRT_from_dir}
\title{Create a VRT file from .tif files}
\usage{
create_VRT_from_dir(dir_tifs, output_path_VRT, verbose = FALSE)
}
\arguments{
\item{dir_tifs}{a valid path to a directory where the .tif files are saved}

\item{output_path_VRT}{a valid path to a file where the VRT will be saved}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}
}
\value{
it doesn't return an object but it saves the output to a file
}
\description{
Create a VRT file from .tif files
}
\examples{

\dontrun{

#....................................
# create a directory to save the .tif
# files and a WKT of a samplel AOI
#....................................

DIR_SAVE = file.path(Sys.getenv('HOME'), 'DIR_SAVE_DEM')
if (!dir.exists(DIR_SAVE)) dir.create(DIR_SAVE)

WKT='POLYGON((61.5234 27.0591, 63.6328 27.0591, 63.6328 28.1495, 61.5234 28.1495, 61.5234 27.0591))'

sf_obj = sf::st_as_sfc(WKT, crs = 4326)
sf_obj = sf::st_make_valid(sf_obj)

#......................
# download 90 meter DEM
#......................

save_matches = CopernicusDEM::aoi_geom_save_tif_matches(sf_or_file = sf_obj,
                                                        dir_save_tifs = DIR_SAVE,
                                                        resolution = 90,
                                                        crs_value = 4326,
                                                        threads = parallel::detectCores(),
                                                        verbose = TRUE)

#............................
# create a .VRT file from the
# 90m downloaded .tif files
#............................

VRT_out = as.character(glue::glue("{DIR_SAVE}.vrt"))

res_vrt = CopernicusDEM::create_VRT_from_dir(dir_tifs = DIR_SAVE,
                                             output_path_VRT = VRT_out,
                                             verbose = TRUE)

#.................................................
# load the saved .vrt file as raster (which might
# consist of multiple files - mosaic) and plot it
#.................................................

rst = raster::raster(VRT_out)
sp::plot(rst)

}
}
