% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cms_products_list.r
\name{cms_products_list}
\alias{cms_products_list}
\title{List products available from data.marine.copernicus.eu}
\usage{
cms_products_list(..., info_type = c("list", "meta"))
}
\arguments{
\item{...}{Allows you to pass (search) query parameters to apply to the list.
When omitted, the full list of products is returned.}

\item{info_type}{One of \code{"list"} (default) or \code{"meta"}. \code{"list"} returns the actual list
whereas \code{"meta"} returns meta information for the executed query (e.g. number of hits).}
}
\value{
Returns a \code{tibble} of products available from \url{https://data.marine.copernicus.eu} or
a named \code{list} when \code{info_type = "meta"}. Returns \code{NULL} in case on-line services are
unavailable.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Collect a list of products and some brief
descriptions for marine products available from Copernicus
}
\examples{
cms_products_list()

## Query a specific product:
cms_products_list(freeText = "GLOBAL_ANALYSISFORECAST_PHY_001_024")
}
\seealso{
Other product-functions: 
\code{\link{cms_cite_product}()},
\code{\link{cms_product_details}()},
\code{\link{cms_product_metadata}()},
\code{\link{cms_product_services}()}
}
\author{
Pepijn de Vries
}
\concept{product-functions}
