% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.CopulaCenR.R
\name{plot.CopulaCenR}
\alias{plot.CopulaCenR}
\title{Plotting for CopulaCenR fits}
\usage{
\method{plot}{CopulaCenR}(x, y, class = "joint", newdata,
  evalPoints = 50, evalTimes1 = NULL, evalTimes2 = NULL,
  plot_margin = 1, cond_time = NULL, cond_margin = 2, type = "l",
  xlab = "years", ylab = "survival probability", cex.main = 1.4,
  cex.lab = 1.4, cex.axis = 1.4, legend = TRUE, ...)
}
\arguments{
\item{x}{an object of \code{ic_sp_copula} or \code{ic_par_copula} or \code{rc_par_copula}}

\item{y}{new data frame with colname names \code{id}, \code{ind} and \code{covariate}}

\item{class}{one of "joint", "conditional" or "marginal"}

\item{newdata}{new data frame (ignored if \code{y} is included)}

\item{evalPoints}{number of time points to be evaluated in both margins;
default is 50}

\item{evalTimes1}{a vector of times for margin 1 to be evaluated;
default is NULL;
will override evalPoints if non-NULL}

\item{evalTimes2}{a vector of times for margin 2 to be evaluated}

\item{plot_margin}{for \code{class = "marginal"} only; indicator of which margin to plot
(either 1 or 2); default is 1 for margin 1}

\item{cond_time}{for \code{class = "conditional"} only; the time
by which event has occurred in the margin indicated by cond_margin;
must be smaller than the largest observed time}

\item{cond_margin}{for \code{class = "conditional"} only; indicator of the margin
where event has occurred (either 1 or 2); default is 2 for margin 2}

\item{type}{type of plot with default \code{type = "l"}.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the x axis.}

\item{cex.main}{cex for main.}

\item{cex.lab}{cex for lab.}

\item{cex.axis}{cex for axis.}

\item{legend}{whether to show legend with default \code{legend = TRUE}.}

\item{...}{further arguments}
}
\value{
a 3D joint survival distribution plot if \code{class = "joint"};
a 2D survival distribution plot if \code{class} = \code{"marginal"} or \code{"conditional"}.
}
\description{
Plotting for CopulaCenR fits from \code{ic_sp_copula}, \code{ic_par_copula}, \code{rc_par_copula}
}
\details{
y must be a data frame with columns \code{id} (subject id),
\code{ind} (1,2 for two margins) and \code{covariates}. \cr
The argument class determines the plot:
\code{"joint"} for joint survival probabilities,
\code{"conditional"} for conditional probabilities and
\code{"marginal"} for marginal probabilities.

The function evaluates on a series of time points
(given by \code{evalPoints} or \code{evalTimes};
\code{evalTimes} will override \code{evalPoints}).
By default, the time points are automatically
selected by specifying the number of points (\code{evalPoints = 50}).
Users can also provide the specific time points through \code{evalTimes1} and
\code{evalTimes2} for the two margins, respectively.
When \code{class} \code{= "conditional"}, only \code{evalTimes1} is needed
and the evaluation times are actually \code{evalTimes1} plus \code{cond_time}. \cr

If \code{class} \code{= "conditional"}, one needs to specify the margin
that has the event (by \code{cond_margin})
and time when the event has occurred (by \code{cond_time}).
For example, if \code{cond_margin = 2} and \code{cond_time = 5},
then the function produces the conditional survival probability
(after time 5) in margin 1 given that margin 2 has got an event by time 5.
This measurement is useful for predicting the second event
given the first event has occurred. See the example for details.\cr

If \code{class = "marginal"}, one needs to specify which margin to plot
through the argument \code{plot_margin}. See the example for details. \cr
}
\examples{
data(AREDS)
# fit a Copula2-Sieve model
copula2_sp <- ic_sp_copula(data = AREDS, copula = "Copula2",
              l = 0, u = 15, m = 3, r = 3,
              var_list = c("ENROLLAGE","rs2284665","SevScaleBL"))
newdata = data.frame(id = rep(1, each=2), ind = rep(c(1,2),1),
                     SevScaleBL = rep(3,2), ENROLLAGE = rep(60,2),
                     rs2284665 = c(0,0))
# Plot joint survival probabilities
plot(x = copula2_sp, class = "joint", newdata = newdata)

# Plot conditional survival probabilities
plot(x = copula2_sp, class = "conditional", newdata = newdata,
     cond_margin = 2, cond_time = 5, ylim = c(0.25,1),
     ylab = "Conditional Survival Probability")

# Plot marginal survival probabilities
plot(x = copula2_sp, class = "marginal", newdata = newdata,
     plot_margin = 1, ylim = c(0.6,1),
     ylab = "Marginal Survival Probability")
}
