% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcond.R
\name{pcond}
\alias{pcond}
\title{Conditional cdf}
\usage{
pcond(U, V, family, rot = 0, cpar, dfC = NULL)
}
\arguments{
\item{U}{values at which the cdf is evaluated}

\item{V}{value of the conditioning variable in (0,1)}

\item{family}{"gaussian" , "t" , "clayton" ,  "joe", "frank" , "fgm", gumbel", "plackett", "galambos", "huesler-reiss"}

\item{rot}{rotation: 0 (default), 90, 180 (survival), or 270}

\item{cpar}{copula parameter (vector)}

\item{dfC}{degrees of freedom of the Student copula (default is NULL)}
}
\value{
\item{p}{Conditional cdf}
}
\description{
This function computes the conditional cdf C(U|V) for a copula C
}
\examples{
p = pcond(0.1,0.2,"clayton",rot=270,cpar=0.87)
}
\author{
Pavel Krupskii and Bruno N. Remillard, January 20, 2022
}
