% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/correg.R
\name{correg}
\alias{correg}
\title{Estimates the response variable using a structure}
\usage{
correg(X = NULL, Y = NULL, Z = NULL, B = NULL, compl = TRUE,
  expl = FALSE, pred = FALSE, select = "lar", criterion = c("MSE",
  "BIC"), X_test = NULL, Y_test = NULL, intercept = TRUE, K = 10,
  groupe = NULL, Amax = NULL, lambda = 1, returning = FALSE,
  alpha = NULL, g = 5, compl2 = FALSE, explnew = FALSE)
}
\arguments{
\item{X}{the data matrix (covariates) without the intercept}

\item{Y}{The response variable vector}

\item{Z}{The structure (adjacency matrix) between the covariates}

\item{B}{the (p+1)xp matrix associated to Z and that contains the parameters of the sub-regressions}

\item{compl}{boolean to decide if the complete modele is computed}

\item{expl}{boolean to decide if the explicative model is in the output}

\item{pred}{boolean to decide if the predictive model is computed}

\item{select}{selection method in ("lar","lasso","forward.stagewise","stepwise", "elasticnet", "NULL","ridge","adalasso","clere","spikeslab")}

\item{criterion}{the criterion used to compare the models}

\item{X_test}{validation sample}

\item{Y_test}{response for the validation sample}

\item{intercept}{boolean. If FALSE intercept will be set to 0 in each model.}

\item{K}{the number of clusters for cross-validation}

\item{groupe}{a vector to define the groups used for cross-validation (to obtain a reproductible result)}

\item{Amax}{the maximum number of covariates in the final model}

\item{lambda}{parameter for elasticnet (quadratic penalty)}

\item{returning}{boolean : second predictive step (selection on I1 knowing I2 coefficients)}

\item{alpha}{Coefficients of the explicative model to coerce the predictive step. if not NULL explicative step is not computed.}

\item{g}{number of group of variables for clere}

\item{compl2}{boolean to compute regression (OLS only) upon [X_f,epsilon] instead of [X_f,X_r]}

\item{explnew}{alternative estimation}
}
\description{
Estimates the response variable using a structure
}

