% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showdata.R
\name{showdata}
\alias{showdata}
\title{To show the missing values of a dataset}
\usage{
showdata(X = X, what = c("miss", "correl"), pch = 7)
}
\arguments{
\item{X}{the matrix to analyse (matrix with missing values or correlations matrix)}

\item{what}{indicates what to plot. If \code{what="correl"} and \code{X} is a correlation matrix then the plot is a correlation plot. Else it shows the missing values positions in the dataset.}

\item{pch}{for missing, symbol to plot (can set pch="." for large datasets)}
}
\description{
Plot the dataset with marks where there are missing value. It allows to have a quick idea of the structure of missing values (Missing at Random or not for example).
}
\examples{
data <- mtcars
datamiss = Terminator(target = data, wrath = 0.05) # 5\% of missing values
showdata(datamiss) # plot positions of the missing values

# missing values with a structure
datamiss = Terminator(target = data, diag = 1) # diag of missing values
showdata(datamiss) # plot positions of the missing values (no full individuals, no full variable)

opar = par(no.readonly = TRUE)
showdata(X = cor(data), what = "correl")
par(opar)

}
