% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorShrinkVector.R
\name{CorShrinkVector}
\alias{CorShrinkVector}
\title{Adaptive shrinkage of a vector of correlations}
\usage{
CorShrinkVector(corvec, nsamp_vec, zscore_sd_vec = NULL, thresh_up = 0.99,
  thresh_down = -0.99, optmethod = "mixEM", ash.control = list())
}
\arguments{
\item{corvec}{A vector of sample correlations (may contain NAs)}

\item{nsamp_vec}{A vector of the number of samples over which correlations
for each cell of the vector are estimated.}

\item{zscore_sd_vec}{A vector of the sandard error of the Fisher z-scores for each cell
in the vector. May contain NA-s as well. The NA-s in this matrix must
match with the NAs in the \code{corvec} matrix. If provided, it is
used as default. When set to NULL, asymptotic distribution of the Fisher z-scores is used
using \code{nsamp_vec}.}

\item{thresh_up}{Upper threshold for correlations. Defaults to 0.99}

\item{thresh_down}{Lower threshold for correlations. Defaults to -0.99}

\item{optmethod}{The optimization method for EM algorithm - can be one of
two techniques \code{mixEM} (mixture EM) and \code{mixVBEM}
(mixture Variational Bayes EM) approaches.The default approach
is \code{mixEM}.}

\item{ash.control}{The control parameters for adaptive shrinkage}
}
\value{
Returns an adaptively shrunk version of the vector of correlations.
}
\description{
This function performs adaptive shrinkage of a
vector of sample correlations using a mixture normal prior on
Fisher z-scores with a wide range of grid variances.
}
\examples{

 cor_vec <- c(-0.56, -0.4, 0.02, 0.2, 0.9, 0.8, 0.3, 0.1, 0.4)
 nsamp_vec <- c(10, 20, 30, 4, 50, 60, 20, 10, 3)
 out <- CorShrinkVector(corvec = cor_vec, nsamp_vec = nsamp_vec,
                        optmethod = "mixEM")

}
\references{
False Discovery Rates: A New Deal. Matthew Stephens bioRxiv 038216; doi: http://dx.doi.org/10.1101/038216
}
\keyword{adaptive}
\keyword{correlation}
\keyword{shrinkage,}
